/*
 * Decompiled with CFR 0.152.
 */
package com.convertigo.jenkins.plugins.jenkinsPluginsArtifact;

import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.JenkinsPluginException;
import com.convertigo.jenkins.plugins.jenkinsPluginsArtifact.RemoteService;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;

public class Deployment {
    private String serverUrl;
    private HttpClient httpClient;
    private boolean bHttps;
    private int port;
    private String host;
    private String protocol;
    private String authority;
    private String path;
    private boolean bAssembleXsl;
    private boolean bAuthenticated;
    private String userId;
    private String password;
    private RemoteService rs;

    public Deployment() {
        this.serverUrl = "www.convertigo.com";
        this.protocol = "http";
        this.port = 80;
    }

    public Deployment(String serverUrl, String userId, String password) throws JenkinsPluginException {
        this.serverUrl = serverUrl;
        this.httpClient = new HttpClient();
        try {
            URL url = new URL(serverUrl);
            this.protocol = url.getProtocol();
            this.authority = url.getAuthority();
            this.host = url.getHost();
            this.path = url.getPath();
            this.bHttps = "https".equals(url.getProtocol());
            this.bAssembleXsl = false;
            this.bAuthenticated = false;
            this.port = url.getPort() == -1 ? (this.bHttps ? 443 : 80) : url.getPort();
            this.userId = userId;
            this.password = password;
            this.rs = new RemoteService(serverUrl, userId, password);
        }
        catch (MalformedURLException e) {
            throw new JenkinsPluginException("The deployment server is not valid: " + serverUrl + "\n" + e.getMessage());
        }
    }

    public void deployMultiProjects(List<File> projectList) throws JenkinsPluginException {
        int nbrError = 0;
        StringBuffer fullMsgError = new StringBuffer("");
        for (File file : projectList) {
            try {
                this.rs.checkAuthentication();
                if (!this.bAuthenticated) {
                    this.rs.login();
                }
                this.rs.deployArchive(file);
            }
            catch (JenkinsPluginException e) {
                ++nbrError;
                String msgError = "Unable to deploy project " + file.toURI().toString() + "\n";
                fullMsgError.append(msgError);
                fullMsgError.append(e.getMessage() + "\n");
            }
        }
        if (nbrError != 0) {
            throw new JenkinsPluginException(fullMsgError.append("there are " + nbrError + " errors during convertigo deployment process. ").toString());
        }
    }

    public static boolean pingUrl(String address) {
        try {
            URL url = new URL(address);
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setConnectTimeout(5000);
            long startTime = System.currentTimeMillis();
            urlConn.connect();
            long endTime = System.currentTimeMillis();
            if (urlConn.getResponseCode() == 200) {
                System.out.println("Time (ms) : " + (endTime - startTime));
                System.out.println("Ping to " + address + " was success");
                return true;
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean pingUrl(URL url) {
        try {
            HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
            urlConn.setConnectTimeout(2000);
            long startTime = System.currentTimeMillis();
            urlConn.connect();
            long endTime = System.currentTimeMillis();
            if (urlConn.getResponseCode() == 200) {
                System.out.println("Time (ms) : " + (endTime - startTime));
                System.out.println("Ping to " + url.toString() + " was success");
                return true;
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void main(String[] args) {
    }
}

