/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.PaddedAtomicLong;
import com.conversantmedia.util.concurrent.PaddedLong;

public final class AtomicSequence {
    private final PaddedAtomicLong cursor = new PaddedAtomicLong(0L);
    private final PaddedAtomicLong sequence = new PaddedAtomicLong(0L);
    private final PaddedLong sequenceCache = new PaddedLong(0L);

    public long get() {
        return this.sequenceCache.value;
    }

    public long getAtomic() {
        this.sequenceCache.value = this.sequence.get();
        return this.sequenceCache.value;
    }

    public boolean update(long sequence) {
        if (this.cursor.compareAndSet(sequence, sequence + 1L)) {
            return true;
        }
        this.sequenceCache.value = this.sequence.get();
        return false;
    }

    public void commit() {
        this.sequence.set(this.cursor.get());
        this.sequenceCache.value = this.sequence.get();
    }
}

