/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.zadviser.build;

import com.compuware.jenkins.common.configuration.CpwrGlobalConfiguration;
import com.compuware.jenkins.common.configuration.HostConnection;
import com.compuware.jenkins.common.utils.ArgumentUtils;
import com.compuware.jenkins.common.utils.CLIVersionUtils;
import com.compuware.jenkins.zadviser.Messages;
import com.compuware.jenkins.zadviser.build.RemoteSystemProperties;
import com.compuware.jenkins.zadviser.common.configuration.ZAdviserGlobalConfiguration;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.GET;
import org.kohsuke.stapler.verb.POST;

public class ZAdviserUploadData
extends Builder
implements SimpleBuildStep {
    private String connectionId;
    private String uploadDataFile;

    @DataBoundConstructor
    public ZAdviserUploadData(String connectionId, String uploadDataFile) {
        this.connectionId = StringUtils.trimToEmpty((String)connectionId);
        this.uploadDataFile = StringUtils.trimToEmpty((String)uploadDataFile);
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getUploadDataFile() {
        return this.uploadDataFile;
    }

    public void setUploadDataFile(String uploadDataFile) {
        this.uploadDataFile = uploadDataFile;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        String customerId;
        PrintStream logger = listener.getLogger();
        CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
        assert (launcher != null);
        VirtualChannel vChannel = launcher.getChannel();
        FilePath cliDirectory = new FilePath(vChannel, globalConfig.getTopazCLILocation(launcher));
        String cliVersion = CLIVersionUtils.getCLIVersion((FilePath)cliDirectory, (String)"20.2.1");
        CLIVersionUtils.checkCLICompatibility((String)cliVersion, (String)"20.2.1");
        ArgumentListBuilder args = new ArgumentListBuilder();
        assert (vChannel != null);
        Properties remoteProperties = (Properties)vChannel.call((Callable)new RemoteSystemProperties());
        String remoteFileSeparator = remoteProperties.getProperty("file.separator");
        boolean isShell = launcher.isUnix();
        String osFile = isShell ? "ZAdviserCLI.sh" : "ZAdviserCLI.bat";
        String cliScriptFile = globalConfig.getTopazCLILocation(launcher) + remoteFileSeparator + osFile;
        logger.println("cliScriptFile: " + cliScriptFile);
        String cliScriptFileRemote = new FilePath(vChannel, cliScriptFile).getRemote();
        logger.println("cliScriptFileRemote: " + cliScriptFileRemote);
        args.add(cliScriptFileRemote);
        HostConnection connection = globalConfig.getHostConnection(this.getConnectionId());
        String host = ArgumentUtils.escapeForScript((String)connection.getHost());
        args.add(new String[]{"-host", host});
        String topazCliWorkspace = workspace.getRemote() + remoteFileSeparator + "TopazCliWkspc" + UUID.randomUUID().toString();
        logger.println("topazCliWorkspace: " + topazCliWorkspace);
        args.add(new String[]{"-data", topazCliWorkspace});
        args.add(new String[]{"-buildStep", "U"});
        ZAdviserGlobalConfiguration zAdviserGlobalConfiguration = ZAdviserGlobalConfiguration.get();
        Secret accessKey = zAdviserGlobalConfiguration.getAccessKey();
        if (accessKey != null) {
            args.add("-accessKey");
            args.add(accessKey.getPlainText(), true);
        }
        if (StringUtils.isNotEmpty((CharSequence)(customerId = zAdviserGlobalConfiguration.getCustomerId()))) {
            args.add(new String[]{"-customerId", customerId});
        }
        String uploadDataFileStr = ArgumentUtils.escapeForScript((String)this.getUploadDataFile());
        args.add(new String[]{"-uploadDataFile", uploadDataFileStr});
        EnvVars env = run.getEnvironment(listener);
        args.add(new String[]{"-persistData", ArgumentUtils.escapeForScript((String)((String)env.get((Object)"JENKINS_HOME")))});
        FilePath workDir = new FilePath(vChannel, workspace.getRemote());
        workDir.mkdirs();
        int exitValue = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)logger).pwd(workDir).join();
        if (exitValue != 0) {
            throw new AbortException("Call " + osFile + " exited with value = " + exitValue);
        }
        logger.println("Call " + osFile + " exited with value = " + exitValue);
        FilePath topazDataDir = new FilePath(vChannel, topazCliWorkspace);
        topazDataDir.deleteRecursive();
    }

    @Symbol(value={"zAdviserUpload"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        @GET
        public FormValidation doCheckConnectionId(@QueryParameter String connectionId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)connectionId)) {
                return FormValidation.error((String)Messages.checkHostConnectionError());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUploadDataFile(@QueryParameter String uploadDataFile) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)uploadDataFile)) {
                return FormValidation.error((String)Messages.checkUploadDataFileError());
            }
            ZAdviserGlobalConfiguration zAdviserGlobalConfig = ZAdviserGlobalConfiguration.get();
            Secret accessKey = zAdviserGlobalConfig.getAccessKey();
            if (accessKey == null || StringUtils.isBlank((CharSequence)accessKey.getPlainText())) {
                return FormValidation.error((String)Messages.checkMissingAccessKeyError());
            }
            String customerId = zAdviserGlobalConfig.getCustomerId();
            if (StringUtils.isBlank((CharSequence)customerId)) {
                return FormValidation.error((String)Messages.checkMissingCustomerIdError());
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return Messages.zAdviserUploadDataDescriptorDisplayName();
        }

        @POST
        public ListBoxModel doFillConnectionIdItems(@AncestorInPath Jenkins context, @QueryParameter String connectionId, @AncestorInPath Item project) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
            HostConnection[] hostConnections = globalConfig.getHostConnections();
            ListBoxModel model = new ListBoxModel();
            model.add((Object)new ListBoxModel.Option("", "", false));
            for (HostConnection connection : hostConnections) {
                boolean isSelected = false;
                if (connectionId != null) {
                    isSelected = connectionId.matches(connection.getConnectionId());
                }
                model.add((Object)new ListBoxModel.Option(connection.getDescription() + " [" + connection.getHostPort() + ']', connection.getConnectionId(), isSelected));
            }
            return model;
        }
    }
}

