/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.restapi.BuildParms;
import com.compuware.ispw.restapi.HttpMode;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.util.RestApiUtils;
import hudson.FilePath;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface IAction {
    public static final String application = "application";
    public static final String assignmentId = "assignmentId";
    public static final String assignmentPrefix = "assignmentPrefix";
    public static final String autoDeploy = "autoDeploy";
    public static final String changeType = "changeType";
    public static final String containerId = "containerId";
    public static final String containerType = "containerType";
    public static final String credentials = "credentials";
    public static final String currentLevel = "currentLevel";
    public static final String defaultPath = "defaultPath";
    public static final String description = "description";
    public static final String dpenvlst = "dpenvlst";
    public static final String endDate = "endDate";
    public static final String environment = "environment";
    public static final String eventsBody = "events.body";
    public static final String eventsCredentials = "events.credentials";
    public static final String eventsHttpHeaders = "events.httpHeaders";
    public static final String eventsMethod = "events.method";
    public static final String eventsName = "events.name";
    public static final String eventsUrl = "events.url";
    public static final String executionStatus = "executionStatus";
    public static final String group = "group";
    public static final String historical = "historical";
    public static final String httpHeaders = "httpHeaders";
    public static final String includeClosedContainers = "includeClosedContainers";
    public static final String inProgress = "inProgress";
    public static final String lastUpdatedBy = "lastUpdatedBy";
    public static final String level = "level";
    public static final String mname = "mname";
    public static final String moduleName = "moduleName";
    public static final String moduleType = "moduleType";
    public static final String mtype = "mtype";
    public static final String name = "name";
    public static final String operation = "operation";
    public static final String owner = "owner";
    public static final String path = "path";
    public static final String production = "production";
    public static final String referenceNumber = "referenceNumber";
    public static final String refNumber = "refNumber";
    public static final String releaseId = "releaseId";
    public static final String releasePrefix = "releasePrefix";
    public static final String requestId = "requestId";
    public static final String runtimeConfiguration = "runtimeConfiguration";
    public static final String setId = "setId";
    public static final String startDate = "startDate";
    public static final String startingLevel = "startingLevel";
    public static final String stream = "stream";
    public static final String system = "system";
    public static final String tag = "tag";
    public static final String taskId = "taskId";
    public static final String userId = "userId";
    public static final String userTag = "userTag";
    public static final String action = "action";
    public static final String checkoutFromLevel = "checkoutFromLevel";
    public static final String checkout = "checkout";
    public static final String taskName = "taskName";
    public static final String type = "type";

    public IspwRequestBean getIspwRequestBean(String var1, String var2, WebhookToken var3);

    public PrintStream getLogger();

    public void startLog(PrintStream var1, IspwContextPathBean var2, Object var3);

    public Object endLog(PrintStream var1, IspwRequestBean var2, String var3);

    public HttpMode getHttpMode();

    default public String preprocess(String ispwRequestBody, FilePath pathToParmFile, PrintStream logger) throws IOException, InterruptedException {
        return ispwRequestBody;
    }

    default public String preprocess(String automaticRegex, String ispwRequestBody, FilePath pathToParmFile, PrintStream logger, String operation, String pastTenseOp) throws IOException, InterruptedException {
        Matcher runAutomaticallyMatcher;
        Pattern runAutomaticallyPattern = Pattern.compile(automaticRegex, 10);
        if (ispwRequestBody != null && (runAutomaticallyMatcher = runAutomaticallyPattern.matcher(ispwRequestBody)).find()) {
            boolean exists = false;
            try {
                exists = pathToParmFile != null && pathToParmFile.exists();
            }
            catch (IOException | InterruptedException x) {
                x.printStackTrace();
                logger.println("Warn: " + x.getMessage());
            }
            if (exists) {
                ispwRequestBody = runAutomaticallyMatcher.replaceAll("");
                try {
                    logger.println(operation + " parameters will automatically be retrieved from file " + pathToParmFile.toURI());
                    String jsonString = pathToParmFile.readToString();
                    BuildParms buildParms = null;
                    if (jsonString != null && !jsonString.isEmpty()) {
                        buildParms = BuildParms.parse(jsonString);
                    }
                    if (buildParms != null) {
                        ispwRequestBody = this.getRequestBodyUsingAutomaticParms(ispwRequestBody, buildParms);
                    }
                    logger.println("Done reading automaticBuildParams.txt.");
                }
                catch (IOException | InterruptedException e) {
                    ispwRequestBody = "";
                    e.printStackTrace();
                    logger.println("The tasks could not be " + pastTenseOp + " automatically because the following error occurred: " + e.getMessage());
                    throw e;
                }
            } else {
                ispwRequestBody = "";
                logger.println("The tasks could not be " + pastTenseOp + " automatically because the automaticBuildParams.txt file does not exist.");
            }
        }
        if (RestApiUtils.isIspwDebugMode()) {
            logger.println("Using requestBody :\n{" + ispwRequestBody + "\n}");
        }
        return ispwRequestBody;
    }

    default public String getRequestBodyUsingAutomaticParms(String inputRequestBody, BuildParms buildParms) {
        String ispwRequestBody = inputRequestBody;
        String linesToReplaceRegex = "(?i)(^(?!#)( +)?(application|assignmentid|releaseid|taskid|mname|mtype|level)(.+)?$)";
        Pattern linesToReplacePattern = Pattern.compile(linesToReplaceRegex, 10);
        Matcher linesToReplaceMatcher = linesToReplacePattern.matcher(ispwRequestBody);
        ispwRequestBody = linesToReplaceMatcher.replaceAll("");
        StringBuilder requestBodyBuilder = new StringBuilder();
        if (buildParms.getContainerId() != null) {
            requestBodyBuilder.append("assignmentId = " + buildParms.getContainerId());
        }
        if (buildParms.getTaskLevel() != null) {
            requestBodyBuilder.append("\nlevel = " + buildParms.getTaskLevel());
        }
        if (buildParms.getReleaseId() != null) {
            requestBodyBuilder.append("\nreleaseId = " + buildParms.getReleaseId());
        }
        if (buildParms.getTaskIds() != null && !buildParms.getTaskIds().isEmpty()) {
            requestBodyBuilder.append("\ntaskId = ");
            for (String taskId : buildParms.getTaskIds()) {
                requestBodyBuilder.append(taskId + ",");
            }
            requestBodyBuilder.deleteCharAt(requestBodyBuilder.length() - 1);
        }
        requestBodyBuilder.append("\n").append(ispwRequestBody);
        ispwRequestBody = requestBodyBuilder.toString();
        return ispwRequestBody;
    }

    default public void postprocess() {
    }
}

