/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.model.rest.WorkListInfo;
import com.compuware.ispw.model.rest.WorkListResponse;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.AbstractGetAction;
import com.compuware.ispw.restapi.util.RestApiUtils;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class GetWorkListAction
extends AbstractGetAction {
    private static final String[] defaultProps = new String[]{"inProgress", "production", "historical", "startDate", "endDate", "type", "name", "operation", "level", "environment", "application", "stream", "lastUpdatedBy", "owner", "releaseId", "refNumber", "group"};
    private static final String contextPath = "/ispw/{srid}/worklist?inProgress={inProgress}&production={production}&historical={historical}&startDate={startDate}&endDate={endDate}&type={type}&name={name}&operation={operation}&level={level}&environment={environment}&application={application}&stream={stream}&lastUpdatedBy={lastUpdatedBy}&owner={owner}&releaseId={releaseId}&refNumber={refNumber}&group={group}";

    public GetWorkListAction(PrintStream logger) {
        super(logger);
    }

    @Override
    public IspwRequestBean getIspwRequestBean(String srid, String ispwRequestBody, WebhookToken webhookToken) {
        List<String> pathTokens = Arrays.asList(defaultProps);
        IspwRequestBean ispwRequestBean = super.getIspwRequestBean(srid, ispwRequestBody, contextPath, pathTokens);
        String path = ispwRequestBean.getContextPath();
        for (String prop : defaultProps) {
            String searchVal = prop + "={" + prop + "}";
            path = path.replace(searchVal, "");
        }
        if ((path = path.replaceAll("[&]+", "&")).endsWith("&")) {
            path = path.substring(0, path.length() - 1);
        }
        ispwRequestBean.setContextPath(path);
        return ispwRequestBean;
    }

    @Override
    public void startLog(PrintStream logger, IspwContextPathBean ispwContextPathBean, Object jsonObject) {
        logger.println("Get the work list information");
    }

    @Override
    public Object endLog(PrintStream logger, IspwRequestBean ispwRequestBean, String responseJson) {
        String fixedResponseJson = RestApiUtils.fixWorkListResponseJson(responseJson);
        WorkListResponse listResponse = new JsonProcessor().parse(fixedResponseJson, WorkListResponse.class);
        if (listResponse != null) {
            for (WorkListInfo workListInfo : listResponse.getWorkListItems()) {
                logger.println(" ");
                logger.println("Action: " + workListInfo.getAction());
                logger.println("Alternate Name: " + workListInfo.getAlternateName());
                logger.println("Application: " + workListInfo.getApplication());
                logger.println("Assignment ID: " + workListInfo.getAssignmentId());
                logger.println("Clazz: " + workListInfo.getClazz());
                logger.println("Date/Time: " + workListInfo.getDateTime());
                logger.println("Environment: " + workListInfo.getEnvironment());
                logger.println("Group: " + workListInfo.getGroup());
                logger.println("Level: " + workListInfo.getLevel());
                logger.println("Message: " + workListInfo.getMessage());
                logger.println("Name: " + workListInfo.getName());
                logger.println("Operation: " + workListInfo.getOperation());
                logger.println("Owner: " + workListInfo.getOwner());
                logger.println("Path: " + workListInfo.getPath());
                logger.println("Ref Number: " + workListInfo.getRefNumber());
                logger.println("Relative Path: " + workListInfo.getRelativePath());
                logger.println("Release ID: " + workListInfo.getReleaseId());
                logger.println("Stream: " + workListInfo.getStream());
                logger.println("Task ID: " + workListInfo.getTaskId());
                logger.println("Technology: " + workListInfo.getTechnology());
                logger.println("Type: " + workListInfo.getType());
                logger.println("User: " + workListInfo.getUser());
                logger.println("Version: " + workListInfo.getVersion());
            }
        }
        return listResponse;
    }
}

