/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ces.communications.service.data.EventCallback;
import com.compuware.ces.model.BasicAuthentication;
import com.compuware.ces.model.HttpHeader;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.AbstractPostAction;
import com.compuware.ispw.restapi.util.ReflectUtils;
import com.compuware.ispw.restapi.util.RestApiUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class GenericPostAction<T>
extends AbstractPostAction {
    public GenericPostAction(PrintStream logger) {
        super(logger);
    }

    public IspwRequestBean getIspwRequestBean(Class<T> postClazz, String srid, String ispwRequestBody, WebhookToken webhookToken, String contextPath) {
        String[] lines;
        IspwRequestBean bean = new IspwRequestBean();
        IspwContextPathBean ispwContextPathBean = new IspwContextPathBean();
        ispwContextPathBean.setSrid(srid);
        bean.setIspwContextPathBean(ispwContextPathBean);
        String path = contextPath.replace("{srid}", srid);
        List<String> allParams = RestApiUtils.listAllParams(path);
        T postObject = ReflectUtils.newInstance(postClazz);
        bean.setJsonObject(postObject);
        boolean hasEvent = false;
        ArrayList<EventCallback> events = new ArrayList<EventCallback>();
        EventCallback event = new EventCallback();
        events.add(event);
        for (String line : lines = ispwRequestBody.split("\n")) {
            BasicAuthentication auth;
            ArrayList<HttpHeader> httpHeaders;
            int indexOfEqualSign;
            if ((line = StringUtils.trimToEmpty((String)line)).startsWith("#") || (indexOfEqualSign = line.indexOf("=")) == -1) continue;
            String name = StringUtils.trimToEmpty((String)line.substring(0, indexOfEqualSign));
            String value = StringUtils.trimToEmpty((String)line.substring(indexOfEqualSign + 1, line.length()));
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            if (name.equals("httpHeaders")) {
                httpHeaders = RestApiUtils.toHttpHeaders(value);
                if (httpHeaders.isEmpty()) continue;
                ReflectUtils.reflectSetter(postObject, "httpHeaders", value);
                continue;
            }
            if (name.equals("credentials")) {
                auth = RestApiUtils.toBasicAuthentication(value);
                if (auth == null) continue;
                ReflectUtils.reflectSetter(postObject, "credentials", auth);
                continue;
            }
            if (name.equals("events.name")) {
                hasEvent = true;
                event.setName(value);
                continue;
            }
            if (name.equals("events.method")) {
                hasEvent = true;
                event.setMethod(value);
                continue;
            }
            if (name.equals("events.body")) {
                hasEvent = true;
                event.setBody(value);
                continue;
            }
            if (name.equals("events.httpHeaders")) {
                httpHeaders = RestApiUtils.toHttpHeaders(value);
                if (httpHeaders.isEmpty()) continue;
                hasEvent = true;
                event.setHttpHeaders(httpHeaders);
                continue;
            }
            if (name.equals("events.credentials")) {
                auth = RestApiUtils.toBasicAuthentication(value);
                if (auth == null) continue;
                hasEvent = true;
                event.setCredentials(auth);
                continue;
            }
            if (allParams.contains(name)) {
                ReflectUtils.reflectSetter(ispwContextPathBean, name, value);
                path = path.replace("{" + name + "}", ReflectUtils.reflectGetter(ispwContextPathBean, name));
            }
            ReflectUtils.reflectSetter(postObject, name, value);
        }
        if (webhookToken != null && hasEvent) {
            event.setUrl(webhookToken.getURL());
            ReflectUtils.reflectSetter(postObject, "eventCallbacks", events);
        }
        bean.setContextPath(RestApiUtils.cleanContextPath(path));
        JsonProcessor jsonGenerator = new JsonProcessor();
        String jsonRequest = jsonGenerator.generate(postObject);
        bean.setJsonRequest(jsonRequest);
        return bean;
    }
}

