/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi.action;

import com.compuware.ispw.model.rest.DeploymentResponse;
import com.compuware.ispw.restapi.IspwContextPathBean;
import com.compuware.ispw.restapi.IspwRequestBean;
import com.compuware.ispw.restapi.JsonProcessor;
import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.action.SetInfoPostAction;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;

public class CancelDeployment
extends SetInfoPostAction {
    private static final String[] defaultProps = new String[]{"requestId", "runtimeConfiguration"};
    private static final String contextPath = "/ispw/{srid}/deployments/{requestId}/cancel";

    public CancelDeployment(PrintStream logger) {
        super(logger);
    }

    @Override
    public IspwRequestBean getIspwRequestBean(String srid, String ispwRequestBody, WebhookToken webhookToken) {
        return this.getIspwRequestBean(srid, ispwRequestBody, webhookToken, contextPath);
    }

    @Override
    public void startLog(PrintStream logger, IspwContextPathBean ispwContextPathBean, Object jsonObject) {
        String msg = String.format("Cancel the deployment with request ID %s", ispwContextPathBean.getRequestId());
        logger.println(msg);
    }

    @Override
    public Object endLog(PrintStream logger, IspwRequestBean ispwRequestBean, String responseJson) {
        DeploymentResponse deployResp = new JsonProcessor().parse(responseJson, DeploymentResponse.class);
        logger.println("Job to cancel deployment with the request ID " + ispwRequestBean.getIspwContextPathBean().getRequestId() + " is submitted. " + StringUtils.trimToEmpty((String)deployResp.getMessage()));
        return deployResp;
    }
}

