/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi;

import com.compuware.ispw.restapi.WaitForWebhookExecution;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class WebhookRootAction
extends CrumbExclusion
implements UnprotectedRootAction {
    private static final HashMap<String, WaitForWebhookExecution> webhooks = new HashMap();
    private static final HashMap<String, String> alreadyPosted = new HashMap();

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "ispw-webhook-step";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDynamic(StaplerRequest request, StaplerResponse response) {
        WaitForWebhookExecution exec;
        String token = request.getOriginalRestOfPath().substring(1);
        CharBuffer dest = CharBuffer.allocate(1024);
        StringBuffer content = new StringBuffer();
        try {
            BufferedReader reader = request.getReader();
            while (reader.read(dest) > 0) {
                dest.rewind();
                content.append(dest.toString());
            }
        }
        catch (IOException e) {
            response.setStatus(400);
            return;
        }
        Logger.getLogger(WebhookRootAction.class.getName()).info("Webhook called with " + token);
        HashMap<String, WaitForWebhookExecution> hashMap = webhooks;
        synchronized (hashMap) {
            exec = webhooks.remove(token);
            if (exec == null) {
                alreadyPosted.put(token, content.toString());
            }
        }
        if (exec != null) {
            exec.onTriggered(content.toString());
            response.setHeader("Result", "WebhookTriggered");
            response.setStatus(200);
        } else {
            response.setStatus(202);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String registerWebhook(WaitForWebhookExecution exec) {
        Logger.getLogger(WebhookRootAction.class.getName()).info("Registering webhook with token " + exec.getToken());
        HashMap<String, WaitForWebhookExecution> hashMap = webhooks;
        synchronized (hashMap) {
            if (alreadyPosted.containsKey(exec.getToken())) {
                return alreadyPosted.remove(exec.getToken());
            }
            webhooks.put(exec.getToken(), exec);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterWebhook(WaitForWebhookExecution exec) {
        Logger.getLogger(WebhookRootAction.class.getName()).info("Deregistering webhook with token " + exec.getToken());
        HashMap<String, WaitForWebhookExecution> hashMap = webhooks;
        synchronized (hashMap) {
            webhooks.remove(exec.getToken());
        }
    }

    public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/ispw-webhook-step/")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return true;
        }
        return false;
    }
}

