/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.restapi;

import com.compuware.ispw.restapi.WebhookToken;
import com.compuware.ispw.restapi.WebhookTokenManager;
import com.compuware.ispw.restapi.util.RestApiUtils;
import hudson.EnvVars;
import java.net.URI;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class RegisterWebhookExecution
extends AbstractSynchronousStepExecution<WebhookToken> {
    private static final long serialVersionUID = -6718328636399912927L;
    private static Logger logger = Logger.getLogger(RegisterWebhookExecution.class);

    public RegisterWebhookExecution(StepContext context) {
        super(context);
    }

    public WebhookToken run() throws Exception {
        EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
        String token = UUID.randomUUID().toString();
        String jenkinsUrl = (String)envVars.get((Object)"JENKINS_URL");
        if (jenkinsUrl == null || jenkinsUrl.isEmpty()) {
            throw new RuntimeException("JENKINS_URL must be set in the Manage Jenkins console");
        }
        URI baseUri = new URI(jenkinsUrl);
        URI relative = new URI("ispw-webhook-step/" + token);
        URI path = baseUri.resolve(relative);
        WebhookToken webhookToken = new WebhookToken(token, path.toString());
        String buildTag = (String)envVars.get((Object)"BUILD_TAG");
        WebhookTokenManager.getInstance().put(buildTag, webhookToken);
        if (RestApiUtils.isIspwDebugMode()) {
            logger.info((Object)("...registering buildTag=" + buildTag + ", webhookToken=" + webhookToken.toString()));
        }
        return webhookToken;
    }
}

