/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.ispw.git;

import com.compuware.ispw.git.RefMap;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class BranchPatternMatcher {
    private Map<Pattern, RefMap> patternMapping = new HashMap<Pattern, RefMap>();

    public BranchPatternMatcher(Map<String, RefMap> branchPatternToIspwLevel, PrintStream log) {
        if (branchPatternToIspwLevel != null) {
            branchPatternToIspwLevel.entrySet().stream().forEach(entry -> {
                String branchPattern = (String)entry.getKey();
                RefMap refMap = (RefMap)entry.getValue();
                String regex = "";
                try {
                    regex = BranchPatternMatcher.wildcardToRegex(branchPattern);
                    Pattern compiled = Pattern.compile(regex);
                    this.patternMapping.put(compiled, refMap);
                }
                catch (PatternSyntaxException x) {
                    String error = String.format("cannot compile wildcard: %s to regex pattern: %s, ignored!", branchPattern, regex);
                    log.println(error);
                }
            });
        }
    }

    public RefMap match(String refId) {
        String patchedRefId = refId.startsWith("/") ? refId : "/" + refId;
        Optional<Pattern> optional = this.patternMapping.keySet().stream().filter(x -> x.matcher(patchedRefId).find()).findFirst();
        if (optional.isPresent()) {
            Pattern pattern = optional.get();
            return this.patternMapping.get(pattern);
        }
        return null;
    }

    public static String wildcardToRegex(String wildcard) {
        wildcard = wildcard.replaceAll("\\*{2}", "##");
        wildcard = wildcard.replaceAll("[*]", "[^/]*");
        wildcard = wildcard.replaceAll("[\\.]", "[.]");
        wildcard = wildcard.replaceAll("##", ".*");
        return ".*" + wildcard + ".*";
    }
}

