/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.common.utils;

import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    public static String escapeForScript(String input) {
        String output = input;
        if (StringUtils.isNotEmpty((CharSequence)input)) {
            output = StringUtils.replace((String)input, (String)"\"", (String)"\"\"");
            output = ArgumentUtils.wrapInDoubleQuotes(output);
        }
        return output;
    }

    public static String escapeCommaDelimitedPathsForScript(String input) {
        String output = input;
        if (StringUtils.isNotEmpty((CharSequence)input)) {
            output = StringUtils.remove((String)input, (String)"\"");
            output = ArgumentUtils.wrapInDoubleQuotes(output);
        }
        return output;
    }

    public static String wrapInDoubleQuotes(String input) {
        String output = input;
        if (StringUtils.isNotEmpty((CharSequence)input)) {
            output = StringUtils.prependIfMissing((String)input, (CharSequence)"\"", (CharSequence[])new CharSequence[0]);
            output = StringUtils.appendIfMissing((String)output, (CharSequence)"\"", (CharSequence[])new CharSequence[0]);
        }
        return output;
    }

    public static String prefixWithDash(String input) {
        String output = input;
        if (StringUtils.isNotEmpty((CharSequence)input)) {
            output = StringUtils.prependIfMissing((String)input, (CharSequence)"-", (CharSequence[])new CharSequence[0]);
        }
        return output;
    }

    public static Properties convertStringToProperties(String propertiesString) throws IOException {
        Properties properties = new Properties();
        if (StringUtils.isNotEmpty((CharSequence)propertiesString)) {
            String escapedPropertiesString = StringUtils.replace((String)propertiesString, (String)"\\", (String)"\\\\");
            properties.load(new StringReader(escapedPropertiesString));
        }
        return properties;
    }

    public static String resolvePath(String folder, String workspacePath) {
        String resolvedFolderPath = folder;
        Path folderPath = Paths.get(folder, new String[0]);
        if (!folderPath.isAbsolute()) {
            Path absPath = Paths.get(workspacePath, resolvedFolderPath);
            resolvedFolderPath = absPath.toString();
        }
        resolvedFolderPath = ArgumentUtils.escapeForScript(resolvedFolderPath);
        return resolvedFolderPath;
    }
}

