/*
 * Decompiled with CFR 0.152.
 */
package com.compuware.jenkins.common.configuration;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.compuware.jenkins.common.configuration.HostConnection;
import com.compuware.jenkins.common.utils.NumericStringComparator;
import hudson.Extension;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class CpwrGlobalConfiguration
extends GlobalConfiguration {
    private static Logger m_logger = Logger.getLogger("hudson.CpwrGlobalConfiguration");
    private static final String CODE_PAGE_MAPPINGS = "com.compuware.jenkins.common.configuration.codePageMappings";
    private static final String PROTOCOL_MAPPINGS = "com.compuware.jenkins.common.configuration.protocolMappings";
    private static final String HOST_CONN_INSTANCE_ID = "hostConn";
    private static final String DESCRIPTION_ID = "description";
    private static final String HOST_PORT_ID = "hostPort";
    private static final String CODE_PAGE_ID = "codePage";
    private static final String PROTOCOL = "protocol";
    private static final String TIMEOUT_ID = "timeout";
    private static final String CONNECTION_ID = "connectionId";
    private static final String CES_URL_ID = "cesUrl";
    private static final String TOPAZ_CLI_LOCATION_WINDOWS_ID = "topazCLILocationWindows";
    private static final String TOPAZ_CLI_LOCATION_LINUX_ID = "topazCLILocationLinux";
    private static final String DEFAULT_TOPAZ_CLI_LOCATION_WINDOWS = "C:\\Program Files\\Compuware\\Topaz Workbench CLI";
    private static final String DEFAULT_TOPAZ_CLI_LOCATION_LINUX = "/opt/Compuware/TopazCLI";
    private static final String PROTOCOL_NONE = "None";
    private volatile HostConnection[] m_hostConnections = new HostConnection[0];
    private String m_topazCLILocationWindows = "C:\\Program Files\\Compuware\\Topaz Workbench CLI";
    private String m_topazCLILocationLinux = "/opt/Compuware/TopazCLI";
    protected transient boolean m_needsSaving = false;

    public static CpwrGlobalConfiguration get() {
        return (CpwrGlobalConfiguration)((Object)GlobalConfiguration.all().get(CpwrGlobalConfiguration.class));
    }

    public CpwrGlobalConfiguration() {
        this.load();
    }

    public boolean needsSaving() {
        return this.m_needsSaving;
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void jobLoaded() {
        CpwrGlobalConfiguration globalConfig = CpwrGlobalConfiguration.get();
        if (globalConfig.needsSaving()) {
            globalConfig.save();
            m_logger.info("Compuware global configuration has been saved.");
        }
    }

    public HostConnection[] getHostConnections() {
        HostConnection[] hostConnections = new HostConnection[this.m_hostConnections.length];
        for (int i = 0; i < this.m_hostConnections.length; ++i) {
            hostConnections[i] = new HostConnection(this.m_hostConnections[i].getDescription(), this.m_hostConnections[i].getHostPort(), this.m_hostConnections[i].getProtocol(), this.m_hostConnections[i].getCodePage(), this.m_hostConnections[i].getTimeout(), this.m_hostConnections[i].getConnectionId(), this.m_hostConnections[i].getCesUrl());
        }
        return hostConnections;
    }

    public HostConnection getHostConnection(String connectionId) {
        HostConnection hostConnection = null;
        if (connectionId != null) {
            for (HostConnection connection : this.m_hostConnections) {
                if (!connectionId.equalsIgnoreCase(connection.getConnectionId())) continue;
                hostConnection = connection;
                break;
            }
        }
        return hostConnection;
    }

    public void setHostConnections(HostConnection ... connections) {
        this.m_hostConnections = connections;
    }

    public HostConnection getHostConnection(String hostPort, String codePage) {
        HostConnection connection = null;
        String host = StringUtils.substringBefore((String)hostPort, (String)":");
        String port = StringUtils.substringAfter((String)hostPort, (String)":");
        for (HostConnection conn : this.m_hostConnections) {
            if (!conn.getHost().equalsIgnoreCase(host) || !conn.getPort().equalsIgnoreCase(port) || !conn.getCodePage().equalsIgnoreCase(codePage)) continue;
            connection = conn;
            break;
        }
        return connection;
    }

    public void addHostConnection(HostConnection connection) {
        ArrayList<HostConnection> newConnectionsList = new ArrayList<HostConnection>(Arrays.asList(this.m_hostConnections));
        newConnectionsList.add(connection);
        this.setHostConnections(newConnectionsList.toArray(new HostConnection[newConnectionsList.size()]));
        this.m_needsSaving = true;
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        HostConnection[] hostConnectionArray;
        Object jsonValue = json.get(HOST_CONN_INSTANCE_ID);
        if (req != null) {
            List hostConnectionList = req.bindJSONToList(HostConnection.class, jsonValue);
            hostConnectionArray = new HostConnection[hostConnectionList.size()];
            hostConnectionArray = hostConnectionList.toArray(hostConnectionArray);
        } else {
            JSONArray jsonHostConnections = JSONArray.fromObject((Object)jsonValue);
            hostConnectionArray = new HostConnection[jsonHostConnections.size()];
            for (int i = 0; i < jsonHostConnections.size(); ++i) {
                JSONObject jsonHostConnection = jsonHostConnections.getJSONObject(i);
                hostConnectionArray[i] = new HostConnection(jsonHostConnection.getString(DESCRIPTION_ID), jsonHostConnection.getString(HOST_PORT_ID), jsonHostConnection.getString(PROTOCOL), jsonHostConnection.getString(CODE_PAGE_ID), jsonHostConnection.getString(TIMEOUT_ID), jsonHostConnection.getString(CONNECTION_ID), jsonHostConnection.getString(CES_URL_ID));
            }
        }
        this.setHostConnections(hostConnectionArray);
        this.m_topazCLILocationWindows = json.getString(TOPAZ_CLI_LOCATION_WINDOWS_ID);
        this.m_topazCLILocationLinux = json.getString(TOPAZ_CLI_LOCATION_LINUX_ID);
        this.save();
        return true;
    }

    public ListBoxModel doFillProtocolItems() {
        ListBoxModel protocolModel = new ListBoxModel();
        ResourceBundle cpBundle = ResourceBundle.getBundle(PROTOCOL_MAPPINGS);
        Set<String> protocolSet = cpBundle.keySet();
        ArrayList<String> protocolSetList = new ArrayList<String>(protocolSet);
        Collections.sort(protocolSetList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (CpwrGlobalConfiguration.PROTOCOL_NONE.equals(o1) || CpwrGlobalConfiguration.PROTOCOL_NONE.equals(o2)) {
                    return -1;
                }
                return o1.compareTo(o2);
            }
        });
        for (String protocolId : protocolSetList) {
            String protocolDescription = cpBundle.getString(protocolId);
            protocolModel.add(protocolDescription, protocolId);
        }
        return protocolModel;
    }

    public ListBoxModel doFillCodePageItems() {
        ListBoxModel codePageModel = new ListBoxModel();
        ResourceBundle cpBundle = ResourceBundle.getBundle(CODE_PAGE_MAPPINGS);
        Set<String> cpNumberSet = cpBundle.keySet();
        ArrayList<String> cpNumberList = new ArrayList<String>(cpNumberSet);
        Collections.sort(cpNumberList, new NumericStringComparator());
        for (String cpNumber : cpNumberList) {
            String cpDescription = cpBundle.getString(cpNumber);
            codePageModel.add(cpDescription, cpNumber);
        }
        return codePageModel;
    }

    public String getTopazCLILocation(Launcher launcher) {
        if (launcher.isUnix()) {
            return this.m_topazCLILocationLinux;
        }
        return this.m_topazCLILocationWindows;
    }

    public String getTopazCLILocationWindows() {
        return this.m_topazCLILocationWindows;
    }

    public String getTopazCLILocationLinux() {
        return this.m_topazCLILocationLinux;
    }

    public void setTopazCLILocationWindows(String location) {
        this.m_topazCLILocationWindows = location;
    }

    public void setTopazCLILocationLinux(String location) {
        this.m_topazCLILocationLinux = location;
    }

    public StandardUsernamePasswordCredentials getLoginInformation(Item project, String credentialsId) {
        StandardUsernamePasswordCredentials credentials = null;
        List credentialsList = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, Collections.emptyList());
        IdMatcher matcher = new IdMatcher(credentialsId);
        for (StandardUsernamePasswordCredentials c : credentialsList) {
            if (!matcher.matches((Credentials)c)) continue;
            credentials = c;
        }
        return credentials;
    }
}

