// CHECKSTYLE:OFF

package com.compuware.jenkins.common.configuration;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code cliOldUnknownVersionError}: {@code The currently installed

     * Topaz Workbench CLI is not supported. Minimum supported version:

     * {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The currently installed Topaz Workbench CLI is not supported.

     *     Minimum supported version: {0}.}
     */
    public static String cliOldUnknownVersionError(Object arg0) {
        return holder.format("cliOldUnknownVersionError", arg0);
    }

    /**
     * Key {@code cliOldUnknownVersionError}: {@code The currently installed

     * Topaz Workbench CLI is not supported. Minimum supported version:

     * {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The currently installed Topaz Workbench CLI is not supported.

     *     Minimum supported version: {0}.}
     */
    public static Localizable _cliOldUnknownVersionError(Object arg0) {
        return new Localizable(holder, "cliOldUnknownVersionError", arg0);
    }

    /**
     * Key {@code displayNameHostConnection}: {@code Host connection}.
     * 
     * @return
     *     {@code Host connection}
     */
    public static String displayNameHostConnection() {
        return holder.format("displayNameHostConnection");
    }

    /**
     * Key {@code displayNameHostConnection}: {@code Host connection}.
     * 
     * @return
     *     {@code Host connection}
     */
    public static Localizable _displayNameHostConnection() {
        return new Localizable(holder, "displayNameHostConnection");
    }

    /**
     * Key {@code checkCesUrlInvalidError}: {@code The URL is not valid.}.
     * 
     * @return
     *     {@code The URL is not valid.}
     */
    public static String checkCesUrlInvalidError() {
        return holder.format("checkCesUrlInvalidError");
    }

    /**
     * Key {@code checkCesUrlInvalidError}: {@code The URL is not valid.}.
     * 
     * @return
     *     {@code The URL is not valid.}
     */
    public static Localizable _checkCesUrlInvalidError() {
        return new Localizable(holder, "checkCesUrlInvalidError");
    }

    /**
     * Key {@code checkHostPortInvalidPortError}: {@code The port is not

     * valid.}.
     * 
     * @return
     *     {@code The port is not valid.}
     */
    public static String checkHostPortInvalidPortError() {
        return holder.format("checkHostPortInvalidPortError");
    }

    /**
     * Key {@code checkHostPortInvalidPortError}: {@code The port is not

     * valid.}.
     * 
     * @return
     *     {@code The port is not valid.}
     */
    public static Localizable _checkHostPortInvalidPortError() {
        return new Localizable(holder, "checkHostPortInvalidPortError");
    }

    /**
     * Key {@code cliParseXmlError}: {@code Unable to parse Topaz Workbench

     * CLI version.xml.}.
     * 
     * @return
     *     {@code Unable to parse Topaz Workbench CLI version.xml.}
     */
    public static String cliParseXmlError() {
        return holder.format("cliParseXmlError");
    }

    /**
     * Key {@code cliParseXmlError}: {@code Unable to parse Topaz Workbench

     * CLI version.xml.}.
     * 
     * @return
     *     {@code Unable to parse Topaz Workbench CLI version.xml.}
     */
    public static Localizable _cliParseXmlError() {
        return new Localizable(holder, "cliParseXmlError");
    }

    /**
     * Key {@code checkHostPortFormatError}: {@code The host:port must

     * contain a single colon character.}.
     * 
     * @return
     *     {@code The host:port must contain a single colon character.}
     */
    public static String checkHostPortFormatError() {
        return holder.format("checkHostPortFormatError");
    }

    /**
     * Key {@code checkHostPortFormatError}: {@code The host:port must

     * contain a single colon character.}.
     * 
     * @return
     *     {@code The host:port must contain a single colon character.}
     */
    public static Localizable _checkHostPortFormatError() {
        return new Localizable(holder, "checkHostPortFormatError");
    }

    /**
     * Key {@code cliOldVersionError}: {@code The currently installed Topaz

     * Workbench CLI version {0} is not supported. Minimum supported version:

     * {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The currently installed Topaz Workbench CLI version {0} is not

     *     supported. Minimum supported version: {1}.}
     */
    public static String cliOldVersionError(Object arg0, Object arg1) {
        return holder.format("cliOldVersionError", arg0, arg1);
    }

    /**
     * Key {@code cliOldVersionError}: {@code The currently installed Topaz

     * Workbench CLI version {0} is not supported. Minimum supported version:

     * {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The currently installed Topaz Workbench CLI version {0} is not

     *     supported. Minimum supported version: {1}.}
     */
    public static Localizable _cliOldVersionError(Object arg0, Object arg1) {
        return new Localizable(holder, "cliOldVersionError", arg0, arg1);
    }

    /**
     * Key {@code checkHostPortEmptyError}: {@code A host:port is required.}.
     * 
     * @return
     *     {@code A host:port is required.}
     */
    public static String checkHostPortEmptyError() {
        return holder.format("checkHostPortEmptyError");
    }

    /**
     * Key {@code checkHostPortEmptyError}: {@code A host:port is required.}.
     * 
     * @return
     *     {@code A host:port is required.}
     */
    public static Localizable _checkHostPortEmptyError() {
        return new Localizable(holder, "checkHostPortEmptyError");
    }

    /**
     * Key {@code checkDescriptionEmptyError}: {@code A host description is

     * required.}.
     * 
     * @return
     *     {@code A host description is required.}
     */
    public static String checkDescriptionEmptyError() {
        return holder.format("checkDescriptionEmptyError");
    }

    /**
     * Key {@code checkDescriptionEmptyError}: {@code A host description is

     * required.}.
     * 
     * @return
     *     {@code A host description is required.}
     */
    public static Localizable _checkDescriptionEmptyError() {
        return new Localizable(holder, "checkDescriptionEmptyError");
    }

    /**
     * Key {@code hostConnectionProtocolCliVersionError}: {@code Host

     * connection encryption protocol is not supported in the currently

     * installed Topaz Workbench CLI version {0}. Minimum supported version:

     * {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Host connection encryption protocol is not supported in the

     *     currently installed Topaz Workbench CLI version {0}. Minimum supported

     *     version: {1}.}
     */
    public static String hostConnectionProtocolCliVersionError(Object arg0, Object arg1) {
        return holder.format("hostConnectionProtocolCliVersionError", arg0, arg1);
    }

    /**
     * Key {@code hostConnectionProtocolCliVersionError}: {@code Host

     * connection encryption protocol is not supported in the currently

     * installed Topaz Workbench CLI version {0}. Minimum supported version:

     * {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Host connection encryption protocol is not supported in the

     *     currently installed Topaz Workbench CLI version {0}. Minimum supported

     *     version: {1}.}
     */
    public static Localizable _hostConnectionProtocolCliVersionError(Object arg0, Object arg1) {
        return new Localizable(holder, "hostConnectionProtocolCliVersionError", arg0, arg1);
    }

    /**
     * Key {@code checkTimeoutError}: {@code Value must be a whole integer

     * between 0 and 2147483647.}.
     * 
     * @return
     *     {@code Value must be a whole integer between 0 and 2147483647.}
     */
    public static String checkTimeoutError() {
        return holder.format("checkTimeoutError");
    }

    /**
     * Key {@code checkTimeoutError}: {@code Value must be a whole integer

     * between 0 and 2147483647.}.
     * 
     * @return
     *     {@code Value must be a whole integer between 0 and 2147483647.}
     */
    public static Localizable _checkTimeoutError() {
        return new Localizable(holder, "checkTimeoutError");
    }

    /**
     * Key {@code checkHostPortMissingPortError}: {@code A port is

     * required.}.
     * 
     * @return
     *     {@code A port is required.}
     */
    public static String checkHostPortMissingPortError() {
        return holder.format("checkHostPortMissingPortError");
    }

    /**
     * Key {@code checkHostPortMissingPortError}: {@code A port is

     * required.}.
     * 
     * @return
     *     {@code A port is required.}
     */
    public static Localizable _checkHostPortMissingPortError() {
        return new Localizable(holder, "checkHostPortMissingPortError");
    }

    /**
     * Key {@code cliNotInstalledError}: {@code Topaz Workbench CLI is not

     * installed in the configured directory. Please verify that the 'Topaz

     * Workbench CLI home' parameter is configured.}.
     * 
     * @return
     *     {@code Topaz Workbench CLI is not installed in the configured

     *     directory. Please verify that the 'Topaz Workbench CLI home' parameter

     *     is configured.}
     */
    public static String cliNotInstalledError() {
        return holder.format("cliNotInstalledError");
    }

    /**
     * Key {@code cliNotInstalledError}: {@code Topaz Workbench CLI is not

     * installed in the configured directory. Please verify that the 'Topaz

     * Workbench CLI home' parameter is configured.}.
     * 
     * @return
     *     {@code Topaz Workbench CLI is not installed in the configured

     *     directory. Please verify that the 'Topaz Workbench CLI home' parameter

     *     is configured.}
     */
    public static Localizable _cliNotInstalledError() {
        return new Localizable(holder, "cliNotInstalledError");
    }

    /**
     * Key {@code checkHostPortMissingHostError}: {@code A host is

     * required.}.
     * 
     * @return
     *     {@code A host is required.}
     */
    public static String checkHostPortMissingHostError() {
        return holder.format("checkHostPortMissingHostError");
    }

    /**
     * Key {@code checkHostPortMissingHostError}: {@code A host is

     * required.}.
     * 
     * @return
     *     {@code A host is required.}
     */
    public static Localizable _checkHostPortMissingHostError() {
        return new Localizable(holder, "checkHostPortMissingHostError");
    }

}
