/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.FileExtensionSpec;
import com.commercehub.gradle.plugin.avro.FileUtils;
import com.commercehub.gradle.plugin.avro.OutputDirTask;
import com.commercehub.gradle.plugin.avro.ProcessingState;
import com.commercehub.gradle.plugin.avro.SchemaResolver;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class ResolveAvroDependenciesTask
extends OutputDirTask {
    private final SchemaResolver resolver = new SchemaResolver(this.getProject(), this.getLogger());

    @TaskAction
    protected void process() {
        this.getLogger().info("Found {} files", (Object)this.getInputs().getSourceFiles().getFiles().size());
        this.failOnUnsupportedFiles();
        this.processFiles();
    }

    private void failOnUnsupportedFiles() {
        FileCollection unsupportedFiles = this.filterSources((Spec<? super File>)new NotSpec((Spec)new FileExtensionSpec("avsc")));
        if (!unsupportedFiles.isEmpty()) {
            throw new GradleException(String.format("Unsupported file extension for the following files: %s", unsupportedFiles));
        }
    }

    private void processFiles() {
        int processedFileCount = this.processSchemaFiles();
        this.setDidWork(processedFileCount > 0);
    }

    private int processSchemaFiles() {
        Set inputFiles = this.filterSources(new FileExtensionSpec("avsc")).getFiles();
        ProcessingState processingState = this.resolver.resolve(inputFiles);
        for (Schema schema : processingState.getSchemas()) {
            try {
                String outputPath = schema.getNamespace().replaceAll(Pattern.quote("."), "/") + "/" + schema.getName() + "." + "avsc";
                File outputFile = new File(((Directory)this.getOutputDir().get()).getAsFile(), outputPath);
                String schemaJson = schema.toString(true);
                FileUtils.writeJsonFile(outputFile, schemaJson);
                this.getLogger().debug("Wrote {}", (Object)outputFile.getPath());
            }
            catch (IOException ex) {
                throw new GradleException(String.format("Failed to write resolved schema definition for %s", schema.getFullName()), (Throwable)ex);
            }
        }
        return processingState.getProcessedTotal();
    }
}

