/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.Constants;
import com.commercehub.gradle.plugin.avro.Enums;
import com.commercehub.gradle.plugin.avro.FileExtensionSpec;
import com.commercehub.gradle.plugin.avro.OutputDirTask;
import com.commercehub.gradle.plugin.avro.ProcessingState;
import com.commercehub.gradle.plugin.avro.SchemaResolver;
import com.commercehub.gradle.plugin.avro.SetBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class GenerateAvroJavaTask
extends OutputDirTask {
    private static Set<String> SUPPORTED_EXTENSIONS = new SetBuilder<String>().add("avpr").add("avsc").build();
    private final Property<String> outputCharacterEncoding;
    private final Property<String> stringType;
    private final Property<String> fieldVisibility;
    private final Property<String> templateDirectory;
    private final Property<Boolean> createOptionalGetters;
    private final Property<Boolean> gettersReturnOptional;
    private final Property<Boolean> createSetters;
    private final Property<Boolean> enableDecimalLogicalType;
    private final Property<String> dateTimeLogicalType;
    private final MapProperty<String, Class<? extends LogicalTypes.LogicalTypeFactory>> logicalTypeFactories;
    private final ListProperty<Class<? extends Conversion<?>>> customConversions;
    private final Provider<GenericData.StringType> stringTypeProvider;
    private final Provider<SpecificCompiler.FieldVisibility> fieldVisibilityProvider;
    private final Provider<SpecificCompiler.DateTimeLogicalTypeImplementation> dateTimeLogicalTypeImplementationProvider;
    private final SchemaResolver resolver;

    @Inject
    public GenerateAvroJavaTask(ObjectFactory objects) {
        this.outputCharacterEncoding = objects.property(String.class);
        this.stringType = objects.property(String.class).convention((Object)Constants.DEFAULT_STRING_TYPE);
        this.fieldVisibility = objects.property(String.class).convention((Object)Constants.DEFAULT_FIELD_VISIBILITY);
        this.templateDirectory = objects.property(String.class);
        this.createOptionalGetters = objects.property(Boolean.class).convention((Object)false);
        this.gettersReturnOptional = objects.property(Boolean.class).convention((Object)false);
        this.createSetters = objects.property(Boolean.class).convention((Object)true);
        this.enableDecimalLogicalType = objects.property(Boolean.class).convention((Object)true);
        this.dateTimeLogicalType = objects.property(String.class).convention((Object)Constants.DEFAULT_DATE_TIME_LOGICAL_TYPE);
        this.stringTypeProvider = this.getStringType().map(input -> (GenericData.StringType)Enums.parseCaseInsensitive((String)"stringType", (Enum[])GenericData.StringType.values(), (String)input));
        this.fieldVisibilityProvider = this.getFieldVisibility().map(input -> (SpecificCompiler.FieldVisibility)Enums.parseCaseInsensitive((String)"fieldVisibility", (Enum[])SpecificCompiler.FieldVisibility.values(), (String)input));
        this.dateTimeLogicalTypeImplementationProvider = this.getDateTimeLogicalType().map(input -> (SpecificCompiler.DateTimeLogicalTypeImplementation)Enums.parseCaseInsensitive((String)"dateTimeLogicalType", (Enum[])SpecificCompiler.DateTimeLogicalTypeImplementation.values(), (String)input));
        this.logicalTypeFactories = objects.mapProperty(String.class, Constants.LOGICAL_TYPE_FACTORY_TYPE.getConcreteClass()).convention(Constants.DEFAULT_LOGICAL_TYPE_FACTORIES);
        this.customConversions = objects.listProperty(Constants.CONVERSION_TYPE.getConcreteClass()).convention(Constants.DEFAULT_CUSTOM_CONVERSIONS);
        this.resolver = new SchemaResolver(this.getProject(), this.getLogger());
    }

    @Optional
    @Input
    public Property<String> getOutputCharacterEncoding() {
        return this.outputCharacterEncoding;
    }

    public void setOutputCharacterEncoding(String outputCharacterEncoding) {
        this.outputCharacterEncoding.set((Object)outputCharacterEncoding);
    }

    public void setOutputCharacterEncoding(Charset outputCharacterEncoding) {
        this.setOutputCharacterEncoding(outputCharacterEncoding.name());
    }

    @Input
    public Property<String> getStringType() {
        return this.stringType;
    }

    public void setStringType(GenericData.StringType stringType) {
        this.setStringType(stringType.name());
    }

    public void setStringType(String stringType) {
        this.stringType.set((Object)stringType);
    }

    @Input
    public Property<String> getFieldVisibility() {
        return this.fieldVisibility;
    }

    public void setFieldVisibility(String fieldVisibility) {
        this.fieldVisibility.set((Object)fieldVisibility);
    }

    public void setFieldVisibility(SpecificCompiler.FieldVisibility fieldVisibility) {
        this.setFieldVisibility(fieldVisibility.name());
    }

    @Optional
    @Input
    public Property<String> getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory.set((Object)templateDirectory);
    }

    public Property<Boolean> isCreateSetters() {
        return this.createSetters;
    }

    @Input
    public Property<Boolean> getCreateSetters() {
        return this.createSetters;
    }

    public void setCreateSetters(String createSetters) {
        this.createSetters.set((Object)Boolean.parseBoolean(createSetters));
    }

    public Property<Boolean> isCreateOptionalGetters() {
        return this.createOptionalGetters;
    }

    @Input
    public Property<Boolean> getCreateOptionalGetters() {
        return this.createOptionalGetters;
    }

    public void setCreateOptionalGetters(String createOptionalGetters) {
        this.createOptionalGetters.set((Object)Boolean.parseBoolean(createOptionalGetters));
    }

    public Property<Boolean> isGettersReturnOptional() {
        return this.gettersReturnOptional;
    }

    @Input
    public Property<Boolean> getGettersReturnOptional() {
        return this.gettersReturnOptional;
    }

    public void setGettersReturnOptional(String gettersReturnOptional) {
        this.gettersReturnOptional.set((Object)Boolean.parseBoolean(gettersReturnOptional));
    }

    public Property<Boolean> isEnableDecimalLogicalType() {
        return this.enableDecimalLogicalType;
    }

    @Input
    public Property<Boolean> getEnableDecimalLogicalType() {
        return this.enableDecimalLogicalType;
    }

    public void setEnableDecimalLogicalType(String enableDecimalLogicalType) {
        this.enableDecimalLogicalType.set((Object)Boolean.parseBoolean(enableDecimalLogicalType));
    }

    @Optional
    @Input
    public Property<String> getDateTimeLogicalType() {
        return this.dateTimeLogicalType;
    }

    public void setDateTimeLogicalType(String dateTimeLogicalType) {
        this.dateTimeLogicalType.set((Object)dateTimeLogicalType);
    }

    public void setDateTimeLogicalType(SpecificCompiler.DateTimeLogicalTypeImplementation dateTimeLogicalType) {
        this.setDateTimeLogicalType(dateTimeLogicalType.name());
    }

    @Optional
    @Input
    public MapProperty<String, Class<? extends LogicalTypes.LogicalTypeFactory>> getLogicalTypeFactories() {
        return this.logicalTypeFactories;
    }

    public void setLogicalTypeFactories(Provider<? extends Map<? extends String, ? extends Class<? extends LogicalTypes.LogicalTypeFactory>>> provider) {
        this.logicalTypeFactories.set(provider);
    }

    public void setLogicalTypeFactories(Map<? extends String, ? extends Class<? extends LogicalTypes.LogicalTypeFactory>> logicalTypeFactories) {
        this.logicalTypeFactories.set(logicalTypeFactories);
    }

    @Optional
    @Input
    public ListProperty<Class<? extends Conversion<?>>> getCustomConversions() {
        return this.customConversions;
    }

    public void setCustomConversions(Provider<Iterable<Class<? extends Conversion<?>>>> provider) {
        this.customConversions.set(provider);
    }

    public void setCustomConversions(Iterable<Class<? extends Conversion<?>>> customConversions) {
        this.customConversions.set(customConversions);
    }

    @TaskAction
    protected void process() {
        this.getLogger().debug("Using outputCharacterEncoding {}", this.getOutputCharacterEncoding().getOrNull());
        this.getLogger().debug("Using stringType {}", (Object)((GenericData.StringType)this.stringTypeProvider.get()).name());
        this.getLogger().debug("Using fieldVisibility {}", (Object)((SpecificCompiler.FieldVisibility)this.fieldVisibilityProvider.get()).name());
        this.getLogger().debug("Using templateDirectory '{}'", this.getTemplateDirectory().getOrNull());
        this.getLogger().debug("Using createSetters {}", this.isCreateSetters().get());
        this.getLogger().debug("Using createOptionalGetters {}", this.isCreateOptionalGetters().get());
        this.getLogger().debug("Using gettersReturnOptional {}", this.isGettersReturnOptional().get());
        this.getLogger().debug("Using enableDecimalLogicalType {}", this.isEnableDecimalLogicalType().get());
        this.getLogger().debug("Using dateTimeLogicalType {}", (Object)((SpecificCompiler.DateTimeLogicalTypeImplementation)this.dateTimeLogicalTypeImplementationProvider.get()).name());
        this.getLogger().debug("Using logicalTypeFactories {}", ((Map)this.logicalTypeFactories.get()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Class)e.getValue()).getName())));
        this.getLogger().debug("Using customConversions {}", ((List)this.customConversions.get()).stream().map(v -> v.getName()).collect(Collectors.toList()));
        this.getLogger().info("Found {} files", (Object)this.getInputs().getSourceFiles().getFiles().size());
        this.failOnUnsupportedFiles();
        this.processFiles();
    }

    private void failOnUnsupportedFiles() {
        FileCollection unsupportedFiles = this.filterSources((Spec<? super File>)new NotSpec((Spec)new FileExtensionSpec(SUPPORTED_EXTENSIONS)));
        if (!unsupportedFiles.isEmpty()) {
            throw new GradleException(String.format("Unsupported file extension for the following files: %s", unsupportedFiles));
        }
    }

    private void processFiles() {
        this.registerLogicalTypes();
        int processedFileCount = 0;
        processedFileCount += this.processProtoFiles();
        this.setDidWork((processedFileCount += this.processSchemaFiles()) > 0);
    }

    private int processProtoFiles() {
        int processedFileCount = 0;
        for (File sourceFile : this.filterSources(new FileExtensionSpec("avpr"))) {
            this.processProtoFile(sourceFile);
            ++processedFileCount;
        }
        return processedFileCount;
    }

    private void processProtoFile(File sourceFile) {
        this.getLogger().info("Processing {}", (Object)sourceFile);
        try {
            this.compile(Protocol.parse((File)sourceFile), sourceFile);
        }
        catch (IOException ex) {
            throw new GradleException(String.format("Failed to compile protocol definition file %s", sourceFile), (Throwable)ex);
        }
    }

    private int processSchemaFiles() {
        Set files = this.filterSources(new FileExtensionSpec("avsc")).getFiles();
        ProcessingState processingState = this.resolver.resolve(files);
        for (File file : files) {
            String path = this.getProject().relativePath((Object)file);
            for (Schema schema : processingState.getSchemasForLocation(path)) {
                try {
                    this.compile(schema, file);
                }
                catch (IOException ex) {
                    throw new GradleException(String.format("Failed to compile schema definition file %s", path), (Throwable)ex);
                }
            }
        }
        return processingState.getProcessedTotal();
    }

    private void compile(Protocol protocol, File sourceFile) throws IOException {
        this.compile(new SpecificCompiler(protocol, (SpecificCompiler.DateTimeLogicalTypeImplementation)this.dateTimeLogicalTypeImplementationProvider.get()), sourceFile);
    }

    private void compile(Schema schema, File sourceFile) throws IOException {
        this.compile(new SpecificCompiler(schema, (SpecificCompiler.DateTimeLogicalTypeImplementation)this.dateTimeLogicalTypeImplementationProvider.get()), sourceFile);
    }

    private void compile(SpecificCompiler compiler, File sourceFile) throws IOException {
        compiler.setOutputCharacterEncoding((String)this.getOutputCharacterEncoding().getOrNull());
        compiler.setStringType((GenericData.StringType)this.stringTypeProvider.get());
        compiler.setFieldVisibility((SpecificCompiler.FieldVisibility)this.fieldVisibilityProvider.get());
        if (this.getTemplateDirectory().isPresent()) {
            compiler.setTemplateDir((String)this.getTemplateDirectory().get());
        }
        compiler.setCreateOptionalGetters(((Boolean)this.createOptionalGetters.get()).booleanValue());
        compiler.setGettersReturnOptional(((Boolean)this.gettersReturnOptional.get()).booleanValue());
        compiler.setCreateSetters(((Boolean)this.isCreateSetters().get()).booleanValue());
        compiler.setEnableDecimalLogicalType(((Boolean)this.isEnableDecimalLogicalType().get()).booleanValue());
        this.registerCustomConversions(compiler);
        compiler.compileToDestination(sourceFile, ((Directory)this.getOutputDir().get()).getAsFile());
    }

    private void registerLogicalTypes() {
        Map logicalTypeFactoryMap = (Map)this.logicalTypeFactories.get();
        Set logicalTypeFactoryEntries = logicalTypeFactoryMap.entrySet();
        for (Map.Entry entry : logicalTypeFactoryEntries) {
            String logicalTypeName = (String)entry.getKey();
            Class logicalTypeFactoryClass = (Class)entry.getValue();
            try {
                LogicalTypes.LogicalTypeFactory logicalTypeFactory = (LogicalTypes.LogicalTypeFactory)logicalTypeFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LogicalTypes.register((String)logicalTypeName, (LogicalTypes.LogicalTypeFactory)logicalTypeFactory);
            }
            catch (ReflectiveOperationException ex) {
                this.getLogger().error("Could not instantiate logicalTypeFactory class \"" + logicalTypeFactoryClass.getName() + "\"");
            }
        }
    }

    private void registerCustomConversions(SpecificCompiler compiler) {
        ((List)this.customConversions.get()).forEach(arg_0 -> ((SpecificCompiler)compiler).addCustomConversion(arg_0));
    }
}

