/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.AvroExtension;
import com.commercehub.gradle.plugin.avro.DefaultAvroExtension;
import com.commercehub.gradle.plugin.avro.GenerateAvroJavaTask;
import com.commercehub.gradle.plugin.avro.GradleCompatibility;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class AvroBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        AvroBasePlugin.configureExtension(project);
    }

    private static void configureExtension(Project project) {
        AvroExtension avroExtension = GradleCompatibility.createExtensionWithObjectFactory(project, "avro", DefaultAvroExtension.class);
        project.getTasks().withType(GenerateAvroJavaTask.class).configureEach(task -> {
            task.getOutputCharacterEncoding().convention(avroExtension.getOutputCharacterEncoding());
            task.getStringType().convention(avroExtension.getStringType());
            task.getFieldVisibility().convention(avroExtension.getFieldVisibility());
            task.getTemplateDirectory().convention(avroExtension.getTemplateDirectory());
            task.isCreateSetters().convention(avroExtension.isCreateSetters());
            task.isCreateOptionalGetters().convention(avroExtension.isCreateOptionalGetters());
            task.isGettersReturnOptional().convention(avroExtension.isGettersReturnOptional());
            task.isEnableDecimalLogicalType().convention(avroExtension.isEnableDecimalLogicalType());
            task.getDateTimeLogicalType().convention(avroExtension.getDateTimeLogicalType());
            task.getLogicalTypeFactories().convention(avroExtension.getLogicalTypeFactories());
            task.getCustomConversions().convention(avroExtension.getCustomConversions());
        });
    }
}

