/*
 * Decompiled with CFR 0.152.
 */
package com.coherentlogic.coherent.data.adapter.core.builders.rest;

import com.coherentlogic.coherent.data.adapter.core.builders.CacheableQueryBuilder;
import com.coherentlogic.coherent.data.adapter.core.builders.GetMethodSpecification;
import com.coherentlogic.coherent.data.adapter.core.builders.rest.DebugInterceptor;
import com.coherentlogic.coherent.data.adapter.core.cache.CacheServiceProviderSpecification;
import com.coherentlogic.coherent.data.adapter.core.cache.NullCache;
import com.coherentlogic.coherent.data.adapter.core.command.CommandExecutorSpecification;
import com.coherentlogic.coherent.data.adapter.core.exceptions.ExecutionFailedException;
import com.coherentlogic.coherent.data.adapter.core.exceptions.IllegalValueRuntimeException;
import com.coherentlogic.coherent.data.adapter.core.exceptions.URISyntaxException;
import com.coherentlogic.coherent.data.adapter.core.listeners.QueryBuilderEvent;
import com.coherentlogic.coherent.data.adapter.core.util.WelcomeMessage;
import com.coherentlogic.coherent.data.model.core.domain.SerializableBean;
import java.net.URI;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractRESTQueryBuilder<K>
extends CacheableQueryBuilder<K>
implements GetMethodSpecification {
    private static final Logger log = LoggerFactory.getLogger(AbstractRESTQueryBuilder.class);
    private final RestTemplate restTemplate;
    private final UriBuilder uriBuilder;
    static final String[] WELCOME_MESSAGE = new String[]{"                                                                               ", "    ______      __                         __     __               _           ", "   / ____/___  / /_  ___  ________  ____  / /_   / /  ____  ____ _(_)____      ", "  / /   / __ \\/ __ \\/ _ \\/ ___/ _ \\/ __ \\/ __/  / /  / __ \\/ __ `/ / ___/", " / /___/ /_/ / / / /  __/ /  /  __/ / / / /_   / /__/ /_/ / /_/ / / /__        ", " \\____/\\____/_/ /_/\\___/_/   \\___/_/ /_/\\__/  /_____|____/\\__, /_/\\___/ ", "                                                         /____/                ", "                                                                               ", " Enterprise Data Adapter Client version 2.0.3-RELEASE                          ", "                                                                               ", " Brought to you by: https://coherentlogic.com                                  ", "                                                                               ", " If you need integration with additional data sources or new features then you ", " need to be speaking with us -- email support@coherentlogic.com to start the   ", " conversation.                                                                 ", "                                                                               "};
    public static final String DEFAULT_SEPARATOR = ",";
    private static final DebugInterceptor debugInterceptor;

    static UriBuilder newUriBuilder(String uri) {
        UriBuilder builder = UriBuilder.fromPath((String)uri);
        return builder;
    }

    protected AbstractRESTQueryBuilder(RestTemplate restTemplate, String uri) {
        this(restTemplate, AbstractRESTQueryBuilder.newUriBuilder(uri));
    }

    protected AbstractRESTQueryBuilder(RestTemplate restTemplate, String uri, CommandExecutorSpecification<K> commandExecutor) {
        this(restTemplate, AbstractRESTQueryBuilder.newUriBuilder(uri), commandExecutor);
    }

    protected AbstractRESTQueryBuilder(RestTemplate restTemplate, String uri, CacheServiceProviderSpecification<K> cache, CommandExecutorSpecification<K> commandExecutor) {
        this(restTemplate, AbstractRESTQueryBuilder.newUriBuilder(uri), cache, commandExecutor);
    }

    protected AbstractRESTQueryBuilder(RestTemplate restTemplate, UriBuilder uriBuilder) {
        this(restTemplate, uriBuilder, new NullCache());
    }

    protected AbstractRESTQueryBuilder(RestTemplate restTemplate, UriBuilder uriBuilder, CommandExecutorSpecification<K> commandExecutor) {
        this(restTemplate, uriBuilder, new NullCache(), commandExecutor);
    }

    protected AbstractRESTQueryBuilder(RestTemplate restTemplate, String uri, CacheServiceProviderSpecification<K> cache) {
        this(restTemplate, AbstractRESTQueryBuilder.newUriBuilder(uri), cache);
    }

    protected AbstractRESTQueryBuilder(RestTemplate restTemplate, UriBuilder uriBuilder, CacheServiceProviderSpecification<K> cache) {
        super(cache);
        this.restTemplate = restTemplate;
        this.uriBuilder = uriBuilder;
    }

    protected AbstractRESTQueryBuilder(RestTemplate restTemplate, UriBuilder uriBuilder, CacheServiceProviderSpecification<K> cache, CommandExecutorSpecification<K> commandExecutor) {
        super(cache, commandExecutor);
        this.restTemplate = restTemplate;
        this.uriBuilder = uriBuilder;
    }

    protected AbstractRESTQueryBuilder<K> assertNotNull(String name, Object value) {
        if (name == null || value == null) {
            throw new NullPointerException("The name and value must both be set to non-null values (name: " + name + ", value: " + value + ").");
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding the parameter with name: " + name + " and value: " + value);
        }
        return this;
    }

    protected AbstractRESTQueryBuilder<K> addParameter(String name, Object value) {
        this.assertNotNull(name, value);
        this.uriBuilder.queryParam(name, new Object[]{value.toString()});
        return this;
    }

    protected AbstractRESTQueryBuilder<K> addParameter(String name, DateFormat dateFormat, Date date) {
        this.assertNotNull(name, date);
        String value = dateFormat.format(date);
        this.uriBuilder.queryParam(name, new Object[]{value});
        return this;
    }

    protected AbstractRESTQueryBuilder<K> addParameter(String name, Number value) {
        this.assertNotNull(name, value);
        this.uriBuilder.queryParam(name, new Object[]{value.toString()});
        return this;
    }

    protected AbstractRESTQueryBuilder<K> addParameter(String name, String ... values) {
        return this.addParameter(name, DEFAULT_SEPARATOR, values);
    }

    protected AbstractRESTQueryBuilder<K> addParameter(String name, String separator, String ... values) {
        return this.addParameter(name, separator, Arrays.asList(values));
    }

    protected AbstractRESTQueryBuilder<K> addParameter(String name, String separator, List<String> values) {
        this.assertNotNull(name, values);
        this.assertNotNull("separator", separator);
        String result = "";
        for (String value : values) {
            result = result + value + separator;
        }
        int lastSeparator = result.lastIndexOf(separator);
        result = result.substring(0, lastSeparator);
        this.uriBuilder.queryParam(name, new Object[]{result});
        return this;
    }

    protected Object notNull(String name, Object value) {
        if (value == null) {
            throw new NullPointerException("The variable named " + name + " is null.");
        }
        return value;
    }

    protected String notNull(String name, String value) {
        return this.notNull(name, (Object)value).toString();
    }

    protected Integer notNull(String name, Integer value) {
        return (Integer)this.notNull(name, (Object)value);
    }

    protected Integer notNegative(String name, Integer value) {
        int result = value.compareTo(0);
        if (result == -1) {
            throw new IllegalValueRuntimeException("The value " + value + " for the parameter named " + name + " cannot be negative.");
        }
        return value;
    }

    protected Number notNull(String name, Number value) {
        if (value == null) {
            throw new NullPointerException("The variabled name " + name + " is null.");
        }
        return value;
    }

    protected AbstractRESTQueryBuilder<K> extendPathWith(String value) {
        this.uriBuilder.path(value);
        return this;
    }

    protected AbstractRESTQueryBuilder<K> extendPathWith(Number value) {
        this.uriBuilder.path(this.notNull("value", value).toString());
        return this;
    }

    String replace(String originalText, int key, Object value) {
        return this.replace(originalText, new Integer(key).toString(), value);
    }

    String replace(String originalText, String key, Object value) {
        if (originalText == null || key == null || value == null) {
            throw new NullPointerException("One of the following is null and all three parameters must have non-null references: originalText: " + originalText + ", key: " + key + ", value: " + value);
        }
        String newText = originalText.replace("${" + key + "}", value.toString());
        if (originalText.equals(newText)) {
            throw new URISyntaxException("The URI has not changed after replacing the key " + key + " with the value " + value + " -- check the format of the originalText: " + originalText);
        }
        return newText;
    }

    public <X extends AbstractRESTQueryBuilder<K>> X path(String path, Object ... values) {
        return this.path(path, Arrays.asList(values));
    }

    public <X extends AbstractRESTQueryBuilder<K>> X path(String path, List<Object> values) {
        String result = path;
        int ctr = 0;
        for (Object value : values) {
            result = this.replace(result, ctr++, value);
        }
        return (X)this.extendPathWith(result);
    }

    public <X extends AbstractRESTQueryBuilder<K>> X path(String path, Map<String, ?> values) {
        String result = path;
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            result = this.replace(result, entry.getKey(), entry.getValue());
        }
        return (X)this.extendPathWith(result);
    }

    public <X extends AbstractRESTQueryBuilder<K>> X replaceQuery(String path, Object ... values) {
        return this.replaceQuery(path, Arrays.asList(values));
    }

    public <X extends AbstractRESTQueryBuilder<K>> X replaceQuery(String query, List<Object> values) {
        String result = query;
        int ctr = 0;
        for (Object value : values) {
            result = this.replace(result, ctr++, value);
        }
        this.uriBuilder.replaceQuery(result);
        return (X)this;
    }

    public <X extends AbstractRESTQueryBuilder<K>> X replaceQuery(String query, Map<String, ?> values) {
        String result = query;
        for (Map.Entry<String, ?> entry : values.entrySet()) {
            result = this.replace(result, entry.getKey(), entry.getValue());
        }
        this.uriBuilder.replaceQuery(result);
        return (X)this;
    }

    protected <X extends AbstractRESTQueryBuilder<K>> X withBody(String body) {
        throw new RuntimeException("Method not yet implemented!");
    }

    protected <X extends AbstractRESTQueryBuilder<K>> X withBody(String body, Object ... values) {
        throw new RuntimeException("Method not yet implemented!");
    }

    protected <X extends AbstractRESTQueryBuilder<K>> X withBody(String body, Map<String, ?> ... values) {
        throw new RuntimeException("Method not yet implemented!");
    }

    public String getEscapedURI() {
        URI uri = this.uriBuilder.build(new Object[0]);
        String escapedURI = uri.toASCIIString();
        return escapedURI;
    }

    protected RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected UriBuilder getUriBuilder() {
        return this.uriBuilder;
    }

    protected abstract K getKey();

    public <X extends AbstractRESTQueryBuilder<K>> X debug() {
        this.restTemplate.getInterceptors().add(debugInterceptor);
        return (X)this;
    }

    protected abstract <T> T doExecute(Class<T> var1);

    @Override
    public <T extends SerializableBean> T doGet(Class<T> type) {
        long operationBeganAtMillis = System.currentTimeMillis();
        this.fireQueryBuilderEvent(QueryBuilderEvent.EventType.methodBegins, null, null, operationBeganAtMillis);
        K key = this.getKey();
        SerializableBean result = null;
        CacheServiceProviderSpecification<K> cache = this.getCache();
        this.fireQueryBuilderEvent(QueryBuilderEvent.EventType.preCacheCheck, key, null, operationBeganAtMillis);
        Object cachedObject = cache.get(key);
        if (cachedObject != null && !type.isInstance(cachedObject)) {
            ClassCastException exception = new ClassCastException("The cached object " + cachedObject + " cannot be cast to type " + type + ".");
            this.onException(key, result, exception, operationBeganAtMillis);
        }
        log.debug("Post cache get for key: " + key + " and serializableBean (result): " + cachedObject + " from the cache: " + cache);
        if (cachedObject != null) {
            result = (SerializableBean)cachedObject;
            this.fireQueryBuilderEvent(QueryBuilderEvent.EventType.cacheHit, key, result, operationBeganAtMillis);
        } else if (cachedObject == null) {
            try {
                result = (SerializableBean)this.doExecute(type);
            }
            catch (Throwable cause) {
                this.onException(key, null, (RuntimeException)((Object)new ExecutionFailedException("The call to the doExecute method caused an exception to be thrown (escapedURI: " + this.getEscapedURI() + ")", cause)), operationBeganAtMillis);
            }
            log.debug("Will add key: " + key + " and result: " + result + " to the cache: " + cache);
            cache.put(key, result);
            this.fireQueryBuilderEvent(QueryBuilderEvent.EventType.cacheMiss, key, result, operationBeganAtMillis);
        }
        this.fireQueryBuilderEvent(QueryBuilderEvent.EventType.methodEnds, key, result, operationBeganAtMillis);
        return (T)result;
    }

    void onException(K key, Object value, RuntimeException cause, long operationBeganAtMillis) {
        log.error(cause.getMessage(), (Throwable)cause);
        this.fireQueryBuilderEvent(QueryBuilderEvent.EventType.exceptionThrown, key, null, cause, operationBeganAtMillis, System.currentTimeMillis());
        throw cause;
    }

    public String doGetAsString() {
        return this.doGetAsString(String.class, result -> result);
    }

    public <R> R doGetAsString(Class<R> resultType, Function<String, R> function) {
        return this.doGetAsString(new RestTemplate(), resultType, function);
    }

    protected <R> R doGetAsString(RestTemplate restTemplate, Class<R> resultType, Function<String, R> function) {
        return this.doGetAsString(restTemplate, webMethodCall -> (String)webMethodCall.getForObject(this.getEscapedURI(), String.class, new Object[0]), resultType, function);
    }

    protected <R> R doGetAsString(RestTemplate restTemplate, Function<RestTemplate, String> webMethod, Class<R> resultType, Function<String, R> function) {
        String result;
        log.debug("doGetAsString: method begins; restTemplate: " + restTemplate + ", webMethod: " + webMethod + ", resultType: " + resultType + ", function: " + function);
        try {
            result = webMethod.apply(restTemplate);
        }
        catch (Exception cause) {
            String uri = this.getEscapedURI();
            throw new ExecutionFailedException("The call to webMethod.apply resulted in an exception being thrown (uri: " + uri + ")", cause);
        }
        log.debug("doGetAsString: method ends; result: " + result);
        return function.apply(result);
    }

    @Override
    public String toString() {
        return "AbstractRESTQueryBuilder [restTemplate=" + this.restTemplate + ", uriBuilder=" + this.uriBuilder + ", toString()=" + super.toString() + "]";
    }

    static {
        new WelcomeMessage().addText(WELCOME_MESSAGE).display();
        debugInterceptor = new DebugInterceptor();
    }
}

