package com.coherentlogic.coherent.data.adapter.core.cache;

import com.coherentlogic.coherent.data.model.core.domain.SerializableBean;

/**
 * An interface that can be implemented such that calls to any Cache implementation can be performed.
 *
 * Note that since JSR-107 is not complete at this time, which is why we're not using it in this framework.
 *
 * @author <a href="https://www.linkedin.com/in/thomasfuller">Thomas P. Fuller</a>
 * @author <a href="mailto:support@coherentlogic.com">Support</a>
 *
 * @param <K> The key type.
 * @param <V> The value type.
 */
public interface CacheServiceProviderSpecification<K> {

    /**
     * Method returns the value associated with the given key.
     */
    <V extends SerializableBean> V get (K key);

    /**
     * Method add the key and value to the cache.
     */
    <V extends SerializableBean> void put (K key, V value);
}
