package com.coherentlogic.coherent.data.adapter.core.builders.soap;

import org.springframework.ws.client.core.WebServiceTemplate;

import com.coherentlogic.coherent.data.adapter.core.builders.CacheableQueryBuilder;
import com.coherentlogic.coherent.data.adapter.core.cache.CacheServiceProviderSpecification;
import com.coherentlogic.coherent.data.adapter.core.cache.NullCache;
import com.coherentlogic.coherent.data.model.core.domain.SerializableBean;

/**
 * The foundation for working with SOAP-style web services.
 *
 * @param <K> The key type.
 * @param <V> The value type.
 *
 * @author <a href="https://www.linkedin.com/in/thomasfuller">Thomas P. Fuller</a>
 * @author <a href="mailto:support@coherentlogic.com">Support</a>
 */
public abstract class AbstractSOAPQueryBuilder<K, V extends SerializableBean>
    extends CacheableQueryBuilder<K>
    implements RequestMethodSpecification<V> {

    private final WebServiceTemplate webServiceTemplate;

    public AbstractSOAPQueryBuilder(WebServiceTemplate webServiceTemplate) {
        this (webServiceTemplate, new NullCache<K> ());
    }

    public AbstractSOAPQueryBuilder(
        WebServiceTemplate webServiceTemplate,
        CacheServiceProviderSpecification<K> cache
    ) {
        super(cache);
        this.webServiceTemplate = webServiceTemplate;
    }

    protected WebServiceTemplate getWebServiceTemplate () {
        return webServiceTemplate;
    }
}
