/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.logger.db;

import com.zaxxer.hikari.HikariConfig;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="tx-lcn.logger")
@Component
public class LogDbProperties
extends HikariConfig {
    private static final Logger log = LoggerFactory.getLogger(LogDbProperties.class);
    private boolean enabled = false;
    private boolean onlyError = true;

    public LogDbProperties(@Autowired(required=false) DataSourceProperties dataSourceProperties) {
        if (Objects.isNull(dataSourceProperties) || Objects.isNull(dataSourceProperties.getDriverClassName()) || Objects.isNull(dataSourceProperties.getUrl())) {
            log.info("TxLogger used user's config.");
            return;
        }
        this.setDriverClassName(dataSourceProperties.getDriverClassName());
        this.setJdbcUrl(dataSourceProperties.getUrl());
        this.setUsername(dataSourceProperties.getUsername());
        this.setPassword(dataSourceProperties.getPassword());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogDbProperties)) {
            return false;
        }
        LogDbProperties other = (LogDbProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        return this.isOnlyError() == other.isOnlyError();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogDbProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isOnlyError() ? 79 : 97);
        return result;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOnlyError() {
        return this.onlyError;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setOnlyError(boolean onlyError) {
        this.onlyError = onlyError;
    }

    public String toString() {
        return "LogDbProperties(enabled=" + this.isEnabled() + ", onlyError=" + this.isOnlyError() + ")";
    }
}

