/*
 * Decompiled with CFR 0.152.
 */
package com.coder.mario.android.widget;

import android.content.Context;
import android.database.Observable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;

public class TagsLayout
extends ViewGroup {
    private Adapter mAdapter;
    private final int SPACING_ORIENTATION_H = this.dp2value(6.0f);
    private final int SPACING_ORIENTATION_V;
    private int mSpacingOrientationV = this.SPACING_ORIENTATION_V = this.dp2value(10.0f);
    private int mSpacingOrientationH = this.SPACING_ORIENTATION_H;
    private final TagsLayoutDataObserver mObserver = new TagsLayoutDataObserver();

    public TagsLayout(Context context) {
        super(context);
        this.init();
    }

    public TagsLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TagsLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams params) {
        return new ViewGroup.MarginLayoutParams(params);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int spacingOrientationV = this.getSpacingOrientationV();
        int spacingOrientationH = this.getSpacingOrientationH();
        int width = this.getMeasuredWidth();
        width -= this.getPaddingLeft() + this.getPaddingRight();
        int totalHeight = this.getPaddingTop();
        int lineWidth = 0;
        int lineHeight = 0;
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.getChildAt(i);
            if (null == child || 8 == child.getVisibility()) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            int childHeight = child.getMeasuredHeight();
            int childWidth = child.getMeasuredWidth();
            if (lineWidth + childWidth <= width) {
                lineHeight = Math.max(lineHeight, childHeight);
                lineWidth += childWidth + spacingOrientationH;
                continue;
            }
            totalHeight += lineHeight + (0 == i ? 0 : spacingOrientationV);
            lineHeight = childHeight;
            lineWidth = childWidth + spacingOrientationH;
        }
        totalHeight += lineHeight + this.getPaddingBottom();
        if (0x40000000 != View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)totalHeight, (int)0x40000000);
            this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int spacingOrientationV = this.getSpacingOrientationV();
        int spacingOrientationH = this.getSpacingOrientationH();
        int width = this.getMeasuredWidth();
        int totalHeight = this.getPaddingTop();
        int lineWidth = this.getPaddingLeft();
        int lineHeight = 0;
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.getChildAt(i);
            if (null == child || 8 == child.getVisibility()) continue;
            int childH = child.getMeasuredHeight();
            int childW = child.getMeasuredWidth();
            if (lineWidth + childW <= width) {
                child.layout(lineWidth, totalHeight, lineWidth + childW, totalHeight + childH);
                lineHeight = Math.max(lineHeight, childH);
                lineWidth += childW + spacingOrientationH;
                continue;
            }
            child.layout(this.getPaddingLeft(), totalHeight += lineHeight + (0 == i ? 0 : spacingOrientationV), this.getPaddingLeft() + childW, totalHeight + childH);
            lineWidth = this.getPaddingLeft() + childW + spacingOrientationH;
            lineHeight = childH;
        }
    }

    public void setSpacingOrientationV(int spacing) {
        this.mSpacingOrientationV = spacing;
        this.requestLayout();
    }

    public int getSpacingOrientationV() {
        return this.mSpacingOrientationV;
    }

    public void setSpacingOrientationH(int spacing) {
        this.mSpacingOrientationH = spacing;
        this.requestLayout();
    }

    public int getSpacingOrientationH() {
        return this.mSpacingOrientationH;
    }

    private int dp2value(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setAdapter(Adapter adapter) {
        this.removeAllViews();
        if (null == adapter) {
            this.postInvalidate();
            return;
        }
        this.setAdapterInner(adapter);
    }

    public Adapter getAdapter() {
        return this.mAdapter;
    }

    private void setAdapterInner(Adapter adapter) {
        if (null != this.mAdapter) {
            this.mAdapter.unregisterAdapterDataObserver(this.mObserver);
        }
        if (null != adapter) {
            this.mAdapter = adapter;
            adapter.registerAdapterDataObserver(this.mObserver);
        }
        this.layoutAllChildren();
    }

    private void layoutAllChildren() {
        Adapter adapter = this.getAdapter();
        if (null == adapter) {
            return;
        }
        this.removeAllViews();
        int size = adapter.getCount();
        for (int i = 0; i < size; ++i) {
            View view = adapter.getView(i);
            if (null == view || 8 == view.getVisibility()) continue;
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
            this.addView(view, layoutParams);
        }
    }

    private class TagsLayoutDataObserver
    extends AdapterDataObserver {
        private TagsLayoutDataObserver() {
        }

        @Override
        public void onChanged() {
            TagsLayout.this.layoutAllChildren();
        }
    }

    private abstract class AdapterDataObserver {
        private AdapterDataObserver() {
        }

        public abstract void onChanged();
    }

    private static class AdapterDataObservable
    extends Observable<AdapterDataObserver> {
        private AdapterDataObservable() {
        }

        public void notifyChanged() {
            for (AdapterDataObserver observer : this.mObservers) {
                if (null == observer) continue;
                observer.onChanged();
            }
        }
    }

    public static abstract class Adapter {
        private final AdapterDataObservable mObservable = new AdapterDataObservable();

        public void unregisterAdapterDataObserver(AdapterDataObserver observer) {
            this.mObservable.unregisterObserver(observer);
        }

        public void registerAdapterDataObserver(AdapterDataObserver observer) {
            this.mObservable.registerObserver(observer);
        }

        public final void notifyDataSetChanged() {
            this.mObservable.notifyChanged();
        }

        public abstract View getView(int var1);

        public abstract int getCount();
    }
}

