/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ElementsContainer;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.PageObjectException;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.ElementsContainerCollection;
import com.codeborne.selenide.impl.PageObjectFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.Annotations;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SelenidePageFactory
implements PageObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(SelenidePageFactory.class);

    @Override
    @CheckReturnValue
    @Nonnull
    public <PageObjectClass> PageObjectClass page(Driver driver, Class<PageObjectClass> pageObjectClass) {
        try {
            Constructor<PageObjectClass> constructor = pageObjectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return this.page(driver, constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to create new instance of " + pageObjectClass, e);
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public <PageObjectClass, T extends PageObjectClass> PageObjectClass page(Driver driver, T pageObject) {
        Type[] types = pageObject.getClass().getGenericInterfaces();
        this.initElements(driver, (SearchContext)driver.getWebDriver(), pageObject, types);
        return pageObject;
    }

    public void initElements(Driver driver, SearchContext searchContext, Object page, Type[] genericTypes) {
        for (Class<?> proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            this.initFields(driver, searchContext, page, proxyIn, genericTypes);
        }
    }

    protected void initFields(Driver driver, SearchContext searchContext, Object page, Class<?> proxyIn, Type[] genericTypes) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            if (this.isInitialized(page, field)) continue;
            By selector = this.findSelector(driver, field);
            Object value = this.decorate(page.getClass().getClassLoader(), driver, searchContext, field, selector, genericTypes);
            if (value == null) continue;
            this.setFieldValue(page, field, value);
        }
    }

    @Nonnull
    protected By findSelector(Driver driver, Field field) {
        return new Annotations(field).buildBy();
    }

    protected void setFieldValue(Object page, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(page, value);
        }
        catch (IllegalAccessException e) {
            throw new PageObjectException("Failed to assign field " + field + " to value " + value, e);
        }
    }

    @CheckReturnValue
    protected boolean isInitialized(Object page, Field field) {
        try {
            field.setAccessible(true);
            return field.get(page) != null;
        }
        catch (IllegalAccessException e) {
            throw new PageObjectException("Failed to access field " + field + " in " + page, e);
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ElementsContainer createElementsContainer(Driver driver, SearchContext searchContext, Field field, By selector) {
        try {
            SelenideElement self = ElementFinder.wrap(driver, searchContext, selector, 0);
            return this.initElementsContainer(driver, field, self);
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to create elements container for field " + field.getName(), e);
        }
    }

    @CheckReturnValue
    @Nonnull
    ElementsContainer initElementsContainer(Driver driver, Field field, SelenideElement self) throws ReflectiveOperationException {
        Type[] genericTypes = field.getGenericType() instanceof ParameterizedType ? ((ParameterizedType)field.getGenericType()).getActualTypeArguments() : new Type[]{};
        return this.initElementsContainer(driver, field, self, field.getType(), genericTypes);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ElementsContainer initElementsContainer(Driver driver, Field field, SelenideElement self, Class<?> type, Type[] genericTypes) throws ReflectiveOperationException {
        if (Modifier.isInterface(type.getModifiers())) {
            throw new IllegalArgumentException("Cannot initialize field " + field + ": " + type + " is interface");
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("Cannot initialize field " + field + ": " + type + " is abstract");
        }
        Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        ElementsContainer result = (ElementsContainer)constructor.newInstance(new Object[0]);
        this.initElements(driver, (SearchContext)self, result, genericTypes);
        return result;
    }

    @CheckReturnValue
    @Nullable
    public final Object decorate(ClassLoader loader, Driver driver, SearchContext searchContext, Field field, By selector) {
        Type[] classGenericTypes = field.getDeclaringClass().getGenericInterfaces();
        return this.decorate(loader, driver, searchContext, field, selector, classGenericTypes);
    }

    @CheckReturnValue
    @Nullable
    public Object decorate(ClassLoader loader, Driver driver, SearchContext searchContext, Field field, By selector, Type[] genericTypes) {
        if (ElementsContainer.class.equals(field.getDeclaringClass()) && "self".equals(field.getName())) {
            if (searchContext instanceof SelenideElement) {
                return searchContext;
            }
            logger.warn("Cannot initialize field {}", (Object)field);
            return null;
        }
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return ElementFinder.wrap(driver, searchContext, selector, 0);
        }
        if (ElementsCollection.class.isAssignableFrom(field.getType()) || this.isDecoratableList(field, genericTypes, WebElement.class)) {
            return new ElementsCollection(new BySelectorCollection(driver, searchContext, selector));
        }
        if (ElementsContainer.class.isAssignableFrom(field.getType())) {
            return this.createElementsContainer(driver, searchContext, field, selector);
        }
        if (this.isDecoratableList(field, genericTypes, ElementsContainer.class)) {
            return this.createElementsContainerList(driver, searchContext, field, genericTypes, selector);
        }
        return this.defaultFieldDecorator(searchContext).decorate(loader, field);
    }

    @CheckReturnValue
    @Nonnull
    protected DefaultFieldDecorator defaultFieldDecorator(SearchContext searchContext) {
        return new DefaultFieldDecorator((ElementLocatorFactory)new DefaultElementLocatorFactory(searchContext));
    }

    @CheckReturnValue
    @Nonnull
    protected List<ElementsContainer> createElementsContainerList(Driver driver, SearchContext searchContext, Field field, Type[] genericTypes, By selector) {
        Class<?> listType = this.getListGenericType(field, genericTypes);
        if (listType == null) {
            throw new IllegalArgumentException("Cannot detect list type for " + field);
        }
        return new ElementsContainerCollection(this, driver, searchContext, field, listType, genericTypes, selector);
    }

    @CheckReturnValue
    protected boolean isDecoratableList(Field field, Type[] genericTypes, Class<?> type) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Class<?> listType = this.getListGenericType(field, genericTypes);
        return listType != null && type.isAssignableFrom(listType) && (field.getAnnotation(FindBy.class) != null || field.getAnnotation(FindBys.class) != null);
    }

    @CheckReturnValue
    @Nullable
    protected Class<?> getListGenericType(Field field, Type[] genericTypes) {
        Type fieldType = field.getGenericType();
        if (!(fieldType instanceof ParameterizedType)) {
            return null;
        }
        Type[] actualTypeArguments = ((ParameterizedType)fieldType).getActualTypeArguments();
        Type firstType = actualTypeArguments[0];
        if (firstType instanceof TypeVariable) {
            int indexOfType = this.indexOf(field.getDeclaringClass(), firstType);
            return (Class)genericTypes[indexOfType];
        }
        if (firstType instanceof Class) {
            return (Class)firstType;
        }
        throw new IllegalArgumentException("Cannot detect list type of " + field);
    }

    protected int indexOf(Class<?> klass, Type firstArgument) {
        Object[] objects = Arrays.stream(klass.getTypeParameters()).toArray();
        for (int i = 0; i < objects.length; ++i) {
            if (!objects[i].equals(firstArgument)) continue;
            return i;
        }
        return -1;
    }
}

