/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class CloseDriverCommand {
    private static final Logger log = LoggerFactory.getLogger(CloseDriverCommand.class);

    public void close(Config config, @Nullable WebDriver webDriver, @Nullable SelenideProxyServer selenideProxyServer) {
        long start;
        long threadId = Thread.currentThread().getId();
        if (config.holdBrowserOpen()) {
            log.info("Hold browser and proxy open: {} -> {}, {}", new Object[]{threadId, webDriver, selenideProxyServer});
            return;
        }
        if (webDriver != null) {
            start = System.currentTimeMillis();
            log.info("Close webdriver: {} -> {}...", (Object)threadId, (Object)webDriver);
            this.close(webDriver);
            log.info("Closed webdriver {} in {} ms", (Object)threadId, (Object)(System.currentTimeMillis() - start));
        }
        if (selenideProxyServer != null) {
            start = System.currentTimeMillis();
            log.info("Close proxy server: {} -> {}...", (Object)threadId, (Object)selenideProxyServer);
            selenideProxyServer.shutdown();
            log.info("Closed proxy server {} in {} ms", (Object)threadId, (Object)(System.currentTimeMillis() - start));
        }
    }

    private void close(WebDriver webdriver) {
        try {
            webdriver.quit();
        }
        catch (UnreachableBrowserException e) {
            log.debug("Browser is unreachable", (Throwable)e);
        }
        catch (WebDriverException cannotCloseBrowser) {
            log.error("Cannot close browser: {}", (Object)Cleanup.of.webdriverExceptionMessage(cannotCloseBrowser));
        }
        catch (RuntimeException e) {
            log.error("Cannot close browser", (Throwable)e);
        }
    }
}

