/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.DialogTextMismatch;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.logevents.SelenideLogger;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Alert;

@ParametersAreNonnullByDefault
public class Modal {
    private final Driver driver;

    public Modal(Driver driver) {
        this.driver = driver;
    }

    public String confirm() {
        return this.confirm(null);
    }

    public String confirm(@Nullable String expectedDialogText) {
        return SelenideLogger.get("confirm", StringUtils.defaultString((String)expectedDialogText), () -> {
            Alert alert = this.driver.switchTo().alert();
            String actualDialogText = alert.getText();
            alert.accept();
            Modal.checkDialogText(this.driver, expectedDialogText, actualDialogText);
            return actualDialogText;
        });
    }

    public String prompt() {
        return this.prompt(null, null);
    }

    public String prompt(@Nullable String inputText) {
        return this.prompt(null, inputText);
    }

    public String prompt(@Nullable String expectedDialogText, @Nullable String inputText) {
        String description = StringUtils.defaultString((String)inputText) + " -> " + StringUtils.defaultString((String)expectedDialogText);
        return SelenideLogger.get("prompt", description, () -> {
            Alert alert = this.driver.switchTo().alert();
            String actualDialogText = alert.getText();
            if (inputText != null) {
                alert.sendKeys(inputText);
            }
            alert.accept();
            Modal.checkDialogText(this.driver, expectedDialogText, actualDialogText);
            return actualDialogText;
        });
    }

    public String dismiss() {
        return this.dismiss(null);
    }

    public String dismiss(@Nullable String expectedDialogText) {
        return SelenideLogger.get("dismiss", StringUtils.defaultString((String)expectedDialogText), () -> {
            Alert alert = this.driver.switchTo().alert();
            String actualDialogText = alert.getText();
            alert.dismiss();
            Modal.checkDialogText(this.driver, expectedDialogText, actualDialogText);
            return actualDialogText;
        });
    }

    private static void checkDialogText(Driver driver, @Nullable String expectedDialogText, String actualDialogText) {
        if (expectedDialogText != null && !expectedDialogText.equals(actualDialogText)) {
            DialogTextMismatch assertionError = new DialogTextMismatch(driver, actualDialogText, expectedDialogText);
            throw UIAssertionError.wrap(driver, (Error)((Object)assertionError), driver.config().timeout());
        }
    }
}

