/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl.windows;

import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;

@ParametersAreNonnullByDefault
public class WindowByNameOrHandle
implements ExpectedCondition<WebDriver> {
    private final String nameOrHandleOrTitle;

    public WindowByNameOrHandle(String nameOrHandleOrTitle) {
        this.nameOrHandleOrTitle = nameOrHandleOrTitle;
    }

    @Nullable
    public WebDriver apply(WebDriver driver) {
        try {
            return Objects.requireNonNull(driver).switchTo().window(this.nameOrHandleOrTitle);
        }
        catch (NoSuchWindowException windowWithNameOrHandleNotFound) {
            try {
                return this.windowByTitle(driver, this.nameOrHandleOrTitle);
            }
            catch (NoSuchWindowException e) {
                return null;
            }
        }
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return "window to be available by name or handle or title: " + this.nameOrHandleOrTitle;
    }

    @Nonnull
    private WebDriver windowByTitle(WebDriver driver, String title) {
        Set windowHandles = driver.getWindowHandles();
        for (String windowHandle : windowHandles) {
            driver.switchTo().window(windowHandle);
            if (!title.equals(driver.getTitle())) continue;
            return driver;
        }
        throw new NoSuchWindowException("Window with title not found: " + title);
    }
}

