/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.impl.Clock;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.PageSourceExtractor;
import com.codeborne.selenide.impl.Photographer;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.Screenshot;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ScreenShotLaboratory {
    private static final Logger log = LoggerFactory.getLogger(ScreenShotLaboratory.class);
    private static final ScreenShotLaboratory instance = new ScreenShotLaboratory();
    private static final Pattern REGEX_PLUS = Pattern.compile("\\+");
    private final Photographer photographer;
    private final PageSourceExtractor extractor;
    private final Clock clock;
    protected final List<File> allScreenshots = new ArrayList<File>();
    protected AtomicLong screenshotCounter = new AtomicLong();
    protected ThreadLocal<String> currentContext = ThreadLocal.withInitial(() -> "");
    protected ThreadLocal<List<File>> currentContextScreenshots = new ThreadLocal();
    protected ThreadLocal<List<File>> threadScreenshots = ThreadLocal.withInitial(ArrayList::new);

    public static ScreenShotLaboratory getInstance() {
        return instance;
    }

    protected ScreenShotLaboratory() {
        this(Plugins.inject(Photographer.class), Plugins.inject(PageSourceExtractor.class), new Clock());
    }

    protected ScreenShotLaboratory(Photographer photographer, PageSourceExtractor extractor, Clock clock) {
        this.photographer = photographer;
        this.extractor = extractor;
        this.clock = clock;
    }

    @CheckReturnValue
    @Nonnull
    public Screenshot takeScreenShot(Driver driver, String className, String methodName) {
        return this.takeScreenshot(driver, this.getScreenshotFileName(className, methodName));
    }

    @CheckReturnValue
    @Nonnull
    protected String getScreenshotFileName(String className, String methodName) {
        return className.replace('.', File.separatorChar) + File.separatorChar + methodName + '.' + this.clock.timestamp();
    }

    @CheckReturnValue
    @Nullable
    @Deprecated
    public String takeScreenShot(Driver driver) {
        return this.takeScreenShot(driver, this.generateScreenshotFileName());
    }

    @CheckReturnValue
    @Nullable
    @Deprecated
    public String takeScreenShot(Driver driver, String fileName) {
        return this.takeScreenshot(driver, fileName).getImage();
    }

    @CheckReturnValue
    @Nonnull
    public Screenshot takeScreenshot(Driver driver, String fileName) {
        Screenshot screenshot = this.ifWebDriverStarted(driver, webDriver -> this.ifReportsFolderNotNull(driver.config(), config -> this.takeScreenShot((Config)config, driver, fileName)));
        return screenshot != null ? screenshot : Screenshot.none();
    }

    @CheckReturnValue
    @Nullable
    public <T> T takeScreenShot(Driver driver, OutputType<T> outputType) {
        return (T)this.ifWebDriverStarted(driver, webDriver -> this.photographer.takeScreenshot(driver, outputType).map(screenshot -> this.addToHistoryIfFile(screenshot, outputType)).orElse(null));
    }

    private <T> T addToHistoryIfFile(T screenshot, OutputType<T> outputType) {
        if (outputType == OutputType.FILE) {
            this.addToHistory((File)screenshot);
        }
        return screenshot;
    }

    @CheckReturnValue
    @Nonnull
    private Screenshot takeScreenShot(Config config, Driver driver, String fileName) {
        File image;
        File source = config.savePageSource() ? this.savePageSourceToFile(config, fileName, driver) : null;
        File file = image = config.screenshots() ? this.savePageImageToFile(config, fileName, driver) : null;
        if (image != null) {
            this.addToHistory(image);
        }
        return new Screenshot(this.toUrl(config, image), this.toUrl(config, source));
    }

    @CheckReturnValue
    @Nullable
    public File takeScreenshot(Driver driver, WebElement element) {
        try {
            BufferedImage destination = this.takeScreenshotAsImage(driver, element);
            if (destination != null) {
                return this.writeToFile(driver, destination);
            }
        }
        catch (IOException e) {
            log.error("Failed to take screenshot of {}", (Object)element, (Object)e);
        }
        return null;
    }

    @CheckReturnValue
    @Nullable
    public BufferedImage takeScreenshotAsImage(Driver driver, WebElement element) {
        return this.ifWebDriverStarted(driver, webdriver -> this.ifReportsFolderNotNull(driver.config(), config -> this.takeElementScreenshotAsImage(driver, element).orElse(null)));
    }

    @CheckReturnValue
    @Nonnull
    private Optional<BufferedImage> takeElementScreenshotAsImage(Driver driver, WebElement element) {
        if (!(driver.getWebDriver() instanceof TakesScreenshot)) {
            log.warn("Cannot take screenshot because browser does not support screenshots");
            return Optional.empty();
        }
        return this.photographer.takeScreenshot(driver, OutputType.BYTES).flatMap(screen -> this.cropToElement((byte[])screen, element));
    }

    @CheckReturnValue
    @Nonnull
    private Optional<BufferedImage> cropToElement(byte[] screen, WebElement element) {
        Point elementLocation = element.getLocation();
        try {
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(screen));
            int elementWidth = this.getRescaledElementWidth(element, img);
            int elementHeight = this.getRescaledElementHeight(element, img);
            return Optional.of(img.getSubimage(elementLocation.getX(), elementLocation.getY(), elementWidth, elementHeight));
        }
        catch (IOException e) {
            log.error("Failed to take screenshot of {}", (Object)element, (Object)e);
            return Optional.empty();
        }
        catch (RasterFormatException e) {
            log.warn("Cannot take screenshot because element is not displayed on current screen position");
            return Optional.empty();
        }
    }

    @CheckReturnValue
    @Nonnull
    protected String generateScreenshotFileName() {
        return this.currentContext.get() + this.clock.timestamp() + "." + this.screenshotCounter.getAndIncrement();
    }

    @CheckReturnValue
    @Nullable
    public File takeScreenshot(Driver driver, WebElement iframe, WebElement element) {
        try {
            BufferedImage destination = this.takeScreenshotAsImage(driver, iframe, element);
            if (destination != null) {
                return this.writeToFile(driver, destination);
            }
        }
        catch (IOException e) {
            log.error("Failed to take screenshot of {} inside frame {}", new Object[]{element, iframe, e});
        }
        return null;
    }

    @CheckReturnValue
    @Nonnull
    private File writeToFile(Driver driver, BufferedImage destination) throws IOException {
        File screenshotOfElement = new File(driver.config().reportsFolder(), this.generateScreenshotFileName() + ".png").getAbsoluteFile();
        FileHelper.ensureParentFolderExists(screenshotOfElement);
        ImageIO.write((RenderedImage)destination, "png", screenshotOfElement);
        return screenshotOfElement;
    }

    @CheckReturnValue
    @Nullable
    public BufferedImage takeScreenshotAsImage(Driver driver, WebElement iframe, WebElement element) {
        WebDriver webdriver = this.checkIfFullyValidDriver(driver);
        if (webdriver == null) {
            return null;
        }
        Optional<byte[]> screenshot = this.photographer.takeScreenshot(driver, OutputType.BYTES);
        return screenshot.flatMap(screen -> this.takeScreenshotAsImage(driver, iframe, element, (byte[])screen)).orElse(null);
    }

    @CheckReturnValue
    @Nonnull
    private Optional<BufferedImage> takeScreenshotAsImage(Driver driver, WebElement iframe, WebElement element, byte[] screen) {
        BufferedImage img;
        Point iframeLocation = iframe.getLocation();
        try {
            img = ImageIO.read(new ByteArrayInputStream(screen));
        }
        catch (IOException e) {
            log.error("Failed to take screenshot of {} inside frame {}", new Object[]{element, iframe, e});
            return Optional.empty();
        }
        catch (RasterFormatException ex) {
            log.warn("Cannot take screenshot because iframe is not displayed");
            return Optional.empty();
        }
        int iframeHeight = this.getRescaledElementHeight(iframe, img);
        SelenideTargetLocator switchTo = new SelenideTargetLocator(driver);
        switchTo.frame(iframe);
        int iframeWidth = this.getRescaledIframeWidth(iframe, img, driver.getWebDriver());
        Point elementLocation = element.getLocation();
        int elementWidth = this.getRescaledElementWidth(element, iframeWidth);
        int elementHeight = this.getRescaledElementHeight(element, iframeHeight);
        switchTo.defaultContent();
        try {
            img = img.getSubimage(iframeLocation.getX() + elementLocation.getX(), iframeLocation.getY() + elementLocation.getY(), elementWidth, elementHeight);
        }
        catch (RasterFormatException ex) {
            log.warn("Cannot take screenshot because element is not displayed in iframe");
            return Optional.empty();
        }
        return Optional.of(img);
    }

    @CheckReturnValue
    @Nullable
    private WebDriver checkIfFullyValidDriver(Driver driver) {
        return this.ifWebDriverStarted(driver, this::checkIfFullyValidDriver);
    }

    @CheckReturnValue
    @Nullable
    private WebDriver checkIfFullyValidDriver(WebDriver webdriver) {
        if (!(webdriver instanceof TakesScreenshot)) {
            log.warn("Cannot take screenshot because browser does not support screenshots");
            return null;
        }
        if (!(webdriver instanceof JavascriptExecutor)) {
            log.warn("Cannot take screenshot as driver is not supporting javascript execution");
            return null;
        }
        return webdriver;
    }

    @CheckReturnValue
    @Nullable
    public File takeScreenShotAsFile(Driver driver) {
        return this.ifWebDriverStarted(driver, webDriver -> {
            try {
                return this.photographer.takeScreenshot(driver, OutputType.FILE).map(this::addToHistory).orElse(null);
            }
            catch (Exception e) {
                log.error("Failed to take screenshot in memory", (Throwable)e);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected File addToHistory(File screenshot) {
        if (this.currentContextScreenshots.get() != null) {
            this.currentContextScreenshots.get().add(screenshot);
        }
        List<File> list = this.allScreenshots;
        synchronized (list) {
            this.allScreenshots.add(screenshot);
        }
        this.threadScreenshots.get().add(screenshot);
        return screenshot;
    }

    @CheckReturnValue
    @Nullable
    protected File savePageImageToFile(Config config, String fileName, Driver driver) {
        try {
            Optional scrFile = this.photographer.takeScreenshot(driver, OutputType.BYTES);
            if (!scrFile.isPresent()) {
                log.info("Webdriver doesn't support screenshots");
                return null;
            }
            File imageFile = new File(config.reportsFolder(), fileName + ".png").getAbsoluteFile();
            try {
                FileHelper.writeToFile((byte[])scrFile.get(), imageFile);
            }
            catch (IOException e) {
                log.error("Failed to save screenshot to {}", (Object)imageFile, (Object)e);
            }
            return imageFile;
        }
        catch (WebDriverException e) {
            log.error("Failed to take screenshot to {}", (Object)fileName, (Object)e);
            return null;
        }
    }

    @CheckReturnValue
    @Nonnull
    protected File savePageSourceToFile(Config config, String fileName, Driver driver) {
        return this.extractor.extract(config, driver.getWebDriver(), fileName);
    }

    public void startContext(String className, String methodName) {
        String context = className.replace('.', File.separatorChar) + File.separatorChar + methodName + File.separatorChar;
        this.startContext(context);
    }

    public void startContext(String context) {
        this.currentContext.set(context);
        this.currentContextScreenshots.set(new ArrayList());
    }

    @Nonnull
    public List<File> finishContext() {
        List<File> result = this.currentContextScreenshots.get();
        this.currentContext.set("");
        this.currentContextScreenshots.remove();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    @Nonnull
    public List<File> getScreenshots() {
        List<File> list = this.allScreenshots;
        synchronized (list) {
            return Collections.unmodifiableList(this.allScreenshots);
        }
    }

    @CheckReturnValue
    @Nonnull
    public List<File> getThreadScreenshots() {
        List<File> screenshots = this.threadScreenshots.get();
        return screenshots == null ? Collections.emptyList() : Collections.unmodifiableList(screenshots);
    }

    @CheckReturnValue
    @Nonnull
    public List<File> getContextScreenshots() {
        List<File> screenshots = this.currentContextScreenshots.get();
        return screenshots == null ? Collections.emptyList() : Collections.unmodifiableList(screenshots);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    @Nullable
    public File getLastScreenshot() {
        List<File> list = this.allScreenshots;
        synchronized (list) {
            return this.allScreenshots.isEmpty() ? null : this.allScreenshots.get(this.allScreenshots.size() - 1);
        }
    }

    @CheckReturnValue
    @Nonnull
    public Optional<File> getLastThreadScreenshot() {
        List<File> screenshots = this.threadScreenshots.get();
        return this.getLastScreenshot(screenshots);
    }

    @CheckReturnValue
    @Nonnull
    public Optional<File> getLastContextScreenshot() {
        List<File> screenshots = this.currentContextScreenshots.get();
        return this.getLastScreenshot(screenshots);
    }

    @CheckReturnValue
    @Nonnull
    private Optional<File> getLastScreenshot(@Nullable List<File> screenshots) {
        return screenshots == null || screenshots.isEmpty() ? Optional.empty() : Optional.of(screenshots.get(screenshots.size() - 1));
    }

    @CheckReturnValue
    @Nonnull
    @Deprecated
    public String formatScreenShotPath(Driver driver) {
        return StringUtils.defaultString((String)this.takeScreenshot(driver).getImage(), (String)"");
    }

    @CheckReturnValue
    @Nonnull
    public Screenshot takeScreenshot(Driver driver) {
        Screenshot screenshot = this.ifWebDriverStarted(driver, webDriver -> this.ifReportsFolderNotNull(driver.config(), config -> this.takeScreenShot((Config)config, driver, this.generateScreenshotFileName())));
        return screenshot != null ? screenshot : Screenshot.none();
    }

    @CheckReturnValue
    @Nullable
    private String toUrl(Config config, @Nullable File file) {
        if (file == null) {
            return null;
        }
        if (config.reportsUrl() != null) {
            return this.formatScreenShotURL(config.reportsUrl(), file.getAbsolutePath());
        }
        try {
            return file.getCanonicalFile().toURI().toURL().toExternalForm();
        }
        catch (IOException e) {
            return "file://" + file.getAbsolutePath();
        }
    }

    @CheckReturnValue
    @Nonnull
    private String formatScreenShotURL(String reportsURL, String screenshot) {
        Path target;
        Path current = Paths.get(System.getProperty("user.dir"), new String[0]);
        String screenShotPath = ScreenShotLaboratory.isInsideFolder(current, target = Paths.get(screenshot, new String[0]).normalize()) ? current.relativize(target).toString().replace('\\', '/') : target.toFile().getName();
        return this.normalizeURL(reportsURL, screenShotPath);
    }

    @CheckReturnValue
    @Nonnull
    private String normalizeURL(String reportsURL, String path) {
        return this.appendSlash(reportsURL) + this.encodePath(path);
    }

    @CheckReturnValue
    @Nonnull
    private String appendSlash(String url) {
        return url.endsWith("/") ? url : url + "/";
    }

    @CheckReturnValue
    @Nonnull
    String encodePath(String path) {
        return REGEX_PLUS.matcher(Arrays.stream(path.split("/")).map(this::encode).collect(Collectors.joining("/"))).replaceAll("%20");
    }

    @CheckReturnValue
    @Nonnull
    private String encode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Cannot encode path segment: {}", (Object)str, (Object)e);
            return str;
        }
    }

    @CheckReturnValue
    private static boolean isInsideFolder(Path root, Path other) {
        return other.startsWith(root.toAbsolutePath());
    }

    @CheckReturnValue
    @Nullable
    private <T> T ifWebDriverStarted(Driver driver, Function<WebDriver, T> lambda) {
        if (!driver.hasWebDriverStarted()) {
            log.warn("Cannot take screenshot because browser is not started");
            return null;
        }
        return lambda.apply(driver.getWebDriver());
    }

    @CheckReturnValue
    @Nullable
    private <T> T ifReportsFolderNotNull(Config config, Function<Config, T> lambda) {
        if (config.reportsFolder() == null) {
            log.error("Cannot take screenshot because reportsFolder is null");
            return null;
        }
        return lambda.apply(config);
    }

    @CheckReturnValue
    private int getRescaledElementWidth(WebElement element, int iframeWidth) {
        int elementWidth = this.getElementWidth(element);
        if (elementWidth > iframeWidth) {
            return iframeWidth - element.getLocation().getX();
        }
        return elementWidth;
    }

    @CheckReturnValue
    private int getRescaledElementHeight(WebElement element, int iframeHeight) {
        int elementHeight = this.getElementHeight(element);
        if (elementHeight > iframeHeight) {
            return iframeHeight - element.getLocation().getY();
        }
        return elementHeight;
    }

    @CheckReturnValue
    private int getRescaledElementWidth(WebElement element, BufferedImage image) {
        if (this.getElementWidth(element) > image.getWidth()) {
            return image.getWidth() - element.getLocation().getX();
        }
        return this.getElementWidth(element);
    }

    @CheckReturnValue
    private int getRescaledElementHeight(WebElement element, BufferedImage image) {
        if (this.getElementHeight(element) > image.getHeight()) {
            return image.getHeight() - element.getLocation().getY();
        }
        return this.getElementHeight(element);
    }

    @CheckReturnValue
    private int getRescaledIframeWidth(WebElement iframe, BufferedImage image, WebDriver driver) {
        if (this.getIframeWidth(driver) > image.getWidth()) {
            return image.getWidth() - iframe.getLocation().getX();
        }
        return this.getIframeWidth(driver);
    }

    @CheckReturnValue
    private int getIframeWidth(WebDriver driver) {
        return ((Long)((JavascriptExecutor)driver).executeScript("return document.body.clientWidth", new Object[0])).intValue();
    }

    @CheckReturnValue
    private int getElementWidth(WebElement element) {
        return element.getSize().getWidth();
    }

    @CheckReturnValue
    private int getElementHeight(WebElement element) {
        return element.getSize().getHeight();
    }
}

