/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.lang.management.ManagementFactory;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class FileNamer {
    private static final Pattern REGEX_MXBEAN_NAME = Pattern.compile("(.*)@.*");

    @CheckReturnValue
    @Nonnull
    public String generateFileName() {
        return String.format("%s_%s_%s", System.currentTimeMillis(), this.pid(), Thread.currentThread().getId());
    }

    @CheckReturnValue
    @Nonnull
    private String pid() {
        return REGEX_MXBEAN_NAME.matcher(ManagementFactory.getRuntimeMXBean().getName()).replaceFirst("$1");
    }
}

