/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.drivercommands.BrowserHealthChecker;
import com.codeborne.selenide.drivercommands.CloseDriverCommand;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class WebDriverWrapper
implements Driver {
    private static final Logger log = LoggerFactory.getLogger(WebDriverWrapper.class);
    private final Config config;
    private final WebDriver webDriver;
    private final SelenideProxyServer selenideProxy;
    private final DownloadsFolder browserDownloadsFolder;
    private final BrowserHealthChecker browserHealthChecker;
    private final CloseDriverCommand closeDriverCommand;

    public WebDriverWrapper(Config config, WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, DownloadsFolder browserDownloadsFolder) {
        this(config, webDriver, selenideProxy, browserDownloadsFolder, new BrowserHealthChecker(), new CloseDriverCommand());
    }

    private WebDriverWrapper(Config config, WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, DownloadsFolder browserDownloadsFolder, BrowserHealthChecker browserHealthChecker, CloseDriverCommand closeDriverCommand) {
        Objects.requireNonNull(config, "config must not be null");
        Objects.requireNonNull(webDriver, "webDriver must not be null");
        this.config = config;
        this.webDriver = webDriver;
        this.selenideProxy = selenideProxy;
        this.browserDownloadsFolder = browserDownloadsFolder;
        this.browserHealthChecker = browserHealthChecker;
        this.closeDriverCommand = closeDriverCommand;
    }

    @Override
    @Nonnull
    public Config config() {
        return this.config;
    }

    @Override
    @Nonnull
    public Browser browser() {
        return new Browser(this.config.browser(), this.config.headless());
    }

    @Override
    public boolean hasWebDriverStarted() {
        return this.webDriver != null;
    }

    @Override
    @Nonnull
    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    @Override
    @Nullable
    public SelenideProxyServer getProxy() {
        return this.selenideProxy;
    }

    @Override
    @Nullable
    public WebDriver getAndCheckWebDriver() {
        if (this.webDriver != null && !this.browserHealthChecker.isBrowserStillOpen(this.webDriver)) {
            log.info("Webdriver has been closed meanwhile");
            this.close();
            return null;
        }
        return this.webDriver;
    }

    @Override
    public DownloadsFolder browserDownloadsFolder() {
        return this.browserDownloadsFolder;
    }

    @Override
    public void close() {
        this.closeDriverCommand.close(this.config, this.webDriver, this.selenideProxy);
    }
}

