/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.collections.ExactTexts;
import com.codeborne.selenide.impl.Html;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ExactTextsCaseSensitiveInAnyOrder
extends ExactTexts {
    public ExactTextsCaseSensitiveInAnyOrder(String ... exactTexts) {
        super(exactTexts);
    }

    public ExactTextsCaseSensitiveInAnyOrder(List<String> exactTexts) {
        super(exactTexts);
    }

    @Override
    @CheckReturnValue
    public boolean test(List<WebElement> elements) {
        if (elements.size() != this.expectedTexts.size()) {
            return false;
        }
        List elementsTexts = elements.stream().map(WebElement::getText).collect(Collectors.toList());
        for (String expectedText : this.expectedTexts) {
            boolean found = false;
            for (String elementText : elementsTexts) {
                if (!Html.text.equalsCaseSensitive(elementText, expectedText)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "Exact texts case sensitive in any order " + this.expectedTexts;
    }
}

