/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Driver;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class LocalStorage {
    private final Driver driver;

    LocalStorage(Driver driver) {
        this.driver = driver;
    }

    @CheckReturnValue
    @Nullable
    public String getItem(String key) {
        return (String)this.driver.executeJavaScript("return localStorage.getItem(arguments[0])", key);
    }

    public void setItem(String key, String value) {
        this.driver.executeJavaScript("localStorage.setItem(arguments[0], arguments[1])", key, value);
    }

    public void removeItem(String key) {
        this.driver.executeJavaScript("localStorage.removeItem(arguments[0])", key);
    }

    public void clear() {
        this.driver.executeJavaScript("localStorage.clear()", new Object[0]);
    }

    public int size() {
        long size = (Long)this.driver.executeJavaScript("return localStorage.length", new Object[0]);
        return (int)size;
    }
}

