/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;

public interface Driver {
    public Config config();

    public Browser browser();

    public boolean hasWebDriverStarted();

    public WebDriver getWebDriver();

    @CheckReturnValue
    @Nullable
    public SelenideProxyServer getProxy();

    public WebDriver getAndCheckWebDriver();

    @CheckReturnValue
    @Nullable
    public DownloadsFolder browserDownloadsFolder();

    public void close();

    default public boolean supportsJavascript() {
        return this.hasWebDriverStarted() && this.getWebDriver() instanceof JavascriptExecutor;
    }

    default public <T> T executeJavaScript(String jsCode, Object ... arguments) {
        return (T)((JavascriptExecutor)this.getWebDriver()).executeScript(jsCode, arguments);
    }

    default public <T> T executeAsyncJavaScript(String jsCode, Object ... arguments) {
        return (T)((JavascriptExecutor)this.getWebDriver()).executeAsyncScript(jsCode, arguments);
    }

    default public void clearCookies() {
        if (this.hasWebDriverStarted()) {
            this.getWebDriver().manage().deleteAllCookies();
        }
    }

    default public String getUserAgent() {
        return (String)this.executeJavaScript("return navigator.userAgent;", new Object[0]);
    }

    default public String source() {
        return this.getWebDriver().getPageSource();
    }

    default public String url() {
        return this.getWebDriver().getCurrentUrl();
    }

    default public String getCurrentFrameUrl() {
        return this.executeJavaScript("return window.location.href", new Object[0]).toString();
    }

    default public SelenideTargetLocator switchTo() {
        return new SelenideTargetLocator(this);
    }

    default public Actions actions() {
        return new Actions(this.getWebDriver());
    }
}

