/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.logevents.EventsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;
import org.slf4j.helpers.NOPLoggerFactory;

@ParametersAreNonnullByDefault
public class SimpleReport {
    private static final Logger log = LoggerFactory.getLogger(SimpleReport.class);
    private static final int MIN_FIRST_COLUMN_WIDTH = 20;
    private static final int MAX_SECOND_COLUMN_WIDTH = 70;
    private static final int MIN_SECOND_COLUMN_WIDTH = 7;
    private static final String TWO_SPACES = "  ";
    private static final String INDENT = System.getProperty("selenide.report.indent", "  ");

    public void start() {
        SimpleReport.checkThatSlf4jIsConfigured();
        SelenideLogger.addListener("simpleReport", new EventsCollector());
    }

    public void finish(String title) {
        EventsCollector logEventListener = (EventsCollector)SelenideLogger.removeListener("simpleReport");
        if (logEventListener == null) {
            log.warn("Can not publish report because Selenide logger has not started.");
            return;
        }
        ArrayList<LogEvent> events = new ArrayList<LogEvent>(logEventListener.events());
        events.sort(Comparator.comparingLong(LogEvent::getStartTime));
        String report = this.generateReport(title, events);
        log.info(report);
    }

    @Nonnull
    @CheckReturnValue
    String generateReport(String title, List<LogEvent> events) {
        List<LogEventWithNestingLevel> eventsWithNestingLevel = this.escapeSubjectAndComputeNestingLevel(events);
        int firstColumnWidth = Math.max(this.maxLocatorLength(eventsWithNestingLevel), 20);
        int secondColumnWidth = Math.min(this.maxSubjectLength(eventsWithNestingLevel), 70);
        int estimatedReportLength = 20 + title.length() + (firstColumnWidth + secondColumnWidth + 35) * (4 + eventsWithNestingLevel.size());
        ReportBuilder report = new ReportBuilder(firstColumnWidth, secondColumnWidth, estimatedReportLength);
        report.appendTitle(title);
        report.appendHeader();
        for (LogEventWithNestingLevel wrapper : eventsWithNestingLevel) {
            report.appendEvent(wrapper);
        }
        report.appendDelimiterLine();
        return report.build();
    }

    private List<LogEventWithNestingLevel> escapeSubjectAndComputeNestingLevel(List<LogEvent> events) {
        ArrayDeque<LogEventWithNestingLevel.SimpleLogEvent> stack = new ArrayDeque<LogEventWithNestingLevel.SimpleLogEvent>();
        ArrayList<LogEventWithNestingLevel> result = new ArrayList<LogEventWithNestingLevel>(events.size());
        for (LogEvent event : events) {
            LogEventWithNestingLevel.SimpleLogEvent eventWithEscapedSubject = new LogEventWithNestingLevel.SimpleLogEvent(event.getElement(), SimpleReport.escape(event.getSubject()), event.getStatus(), event.getDuration(), event.getStartTime(), event.getEndTime(), event.getError());
            while (!stack.isEmpty() && ((LogEventWithNestingLevel.SimpleLogEvent)stack.peekFirst()).getEndTime() <= eventWithEscapedSubject.getStartTime()) {
                stack.removeFirst();
            }
            result.add(new LogEventWithNestingLevel(stack.size(), eventWithEscapedSubject));
            stack.addFirst(eventWithEscapedSubject);
        }
        return result;
    }

    @CheckReturnValue
    private int maxLocatorLength(List<LogEventWithNestingLevel> events) {
        int maxLength = 0;
        for (LogEventWithNestingLevel wrapper : events) {
            int length = wrapper.event.getElement().length() + wrapper.nestingLevel * INDENT.length();
            if (length <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    @CheckReturnValue
    private int maxSubjectLength(List<LogEventWithNestingLevel> events) {
        int maxLength = 7;
        for (LogEventWithNestingLevel wrapper : events) {
            int length = wrapper.event.getSubject().length();
            if (length <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    public void clean() {
        SelenideLogger.removeListener("simpleReport");
    }

    private static void checkThatSlf4jIsConfigured() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (loggerFactory instanceof NOPLoggerFactory || loggerFactory.getLogger("com.codeborne.selenide") instanceof NOPLogger) {
            throw new IllegalStateException("SLF4J is not configured. You will not see any Selenide logs. " + System.lineSeparator() + "  Please add slf4j-simple.jar, slf4j-log4j12.jar or logback-classic.jar to your classpath. " + System.lineSeparator() + "  See https://github.com/selenide/selenide/wiki/slf4j");
        }
    }

    private static String escape(String text) {
        StringBuilder builder = new StringBuilder((int)((double)text.length() * 1.5));
        block8: for (int i = 0; i < text.length(); ++i) {
            char symbol = text.charAt(i);
            switch (symbol) {
                case '\t': {
                    builder.append("\\t");
                    continue block8;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block8;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block8;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block8;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block8;
                }
                case '\u00a0': {
                    builder.append("\\u00A0");
                    continue block8;
                }
                default: {
                    if (symbol <= '\u001f') {
                        builder.append(String.format("\\u%04X", symbol));
                        continue block8;
                    }
                    builder.append(symbol);
                }
            }
        }
        return builder.toString();
    }

    private static class ReportBuilder {
        private final int firstColumnWidth;
        private final int secondColumnWidth;
        private final String delimiterLine;
        private final StringBuilder sb;

        private ReportBuilder(int firstColumnWidth, int secondColumnWidth, int estimatedReportLength) {
            this.firstColumnWidth = firstColumnWidth;
            this.secondColumnWidth = secondColumnWidth;
            this.delimiterLine = '+' + String.join((CharSequence)"+", this.line(firstColumnWidth + 2), this.line(secondColumnWidth + 2), this.line(12), this.line(12)) + '+' + System.lineSeparator();
            this.sb = new StringBuilder(estimatedReportLength);
        }

        private void appendTitle(String title) {
            this.sb.append("Report for ").append(title).append(System.lineSeparator());
            this.sb.append(this.delimiterLine);
        }

        @CheckReturnValue
        @Nonnull
        private String line(int count) {
            return this.repeat("-", count);
        }

        @CheckReturnValue
        @Nonnull
        private String indent(int count) {
            return this.repeat(INDENT, count);
        }

        @CheckReturnValue
        @Nonnull
        private String repeat(String value, int count) {
            return new String(new char[count]).replace("\u0000", value);
        }

        public void appendHeader() {
            this.appendLine(this.sb, this.firstColumnWidth, this.secondColumnWidth, "Element", "Subject", "Status", "ms.");
            this.appendDelimiterLine();
        }

        private void appendLine(StringBuilder sb, int firstColumnWidth, int secondColumnWidth, String element, String subject, String status, String duration) {
            sb.append("| ");
            this.append(sb, element, firstColumnWidth);
            sb.append(" | ");
            this.append(sb, subject, secondColumnWidth);
            sb.append(" | ");
            this.append(sb, status, 10);
            sb.append(" | ");
            this.append(sb, duration, 10);
            sb.append(" |").append(System.lineSeparator());
        }

        private void appendEvent(LogEventWithNestingLevel wrapper) {
            String elementWithIndent = this.indent(wrapper.nestingLevel) + wrapper.event.getElement();
            this.appendLine(this.sb, this.firstColumnWidth, this.secondColumnWidth, elementWithIndent, wrapper.event.getSubject(), wrapper.event.getStatus().name(), String.valueOf(wrapper.event.getDuration()));
        }

        public void appendDelimiterLine() {
            this.sb.append(this.delimiterLine);
        }

        private void append(StringBuilder sb, String text, int minLength) {
            sb.append(text);
            for (int i = text.length(); i < minLength; ++i) {
                sb.append(' ');
            }
        }

        public String build() {
            return this.sb.toString();
        }
    }

    private static final class LogEventWithNestingLevel {
        private final int nestingLevel;
        private final SimpleLogEvent event;

        private LogEventWithNestingLevel(int nestingLevel, SimpleLogEvent event) {
            this.nestingLevel = nestingLevel;
            this.event = event;
        }

        public String toString() {
            return "LogEventWithNestingLevel[" + "nestingLevel=" + this.nestingLevel + "," + "event=" + this.event + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + this.nestingLevel;
            result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (((LogEventWithNestingLevel)arg0).nestingLevel != this.nestingLevel) {
                return false;
            }
            return Objects.equals(((LogEventWithNestingLevel)arg0).event, this.event);
            {
            }
        }

        public int nestingLevel() {
            return this.nestingLevel;
        }

        public SimpleLogEvent event() {
            return this.event;
        }

        private static final class SimpleLogEvent
        implements LogEvent {
            private final String getElement;
            private final String getSubject;
            private final LogEvent.EventStatus getStatus;
            private final long getDuration;
            private final long getStartTime;
            private final long getEndTime;
            private final Throwable getError;

            private SimpleLogEvent(String getElement, String getSubject, LogEvent.EventStatus getStatus, long getDuration, long getStartTime, long getEndTime, Throwable getError) {
                this.getElement = getElement;
                this.getSubject = getSubject;
                this.getStatus = getStatus;
                this.getDuration = getDuration;
                this.getStartTime = getStartTime;
                this.getEndTime = getEndTime;
                this.getError = getError;
            }

            public String toString() {
                return "SimpleLogEvent[" + "getElement=" + this.getElement + "," + "getSubject=" + this.getSubject + "," + "getStatus=" + (Object)((Object)this.getStatus) + "," + "getDuration=" + this.getDuration + "," + "getStartTime=" + this.getStartTime + "," + "getEndTime=" + this.getEndTime + "," + "getError=" + this.getError + "]";
            }

            public int hashCode() {
                int result = 0;
                result = 31 * result + (this.getElement != null ? this.getElement.hashCode() : 0);
                result = 31 * result + (this.getSubject != null ? this.getSubject.hashCode() : 0);
                result = 31 * result + (this.getStatus != null ? this.getStatus.hashCode() : 0);
                result = 31 * result + (int)(this.getDuration ^ this.getDuration >>> 32);
                result = 31 * result + (int)(this.getStartTime ^ this.getStartTime >>> 32);
                result = 31 * result + (int)(this.getEndTime ^ this.getEndTime >>> 32);
                result = 31 * result + (this.getError != null ? this.getError.hashCode() : 0);
                return result;
            }

            public final boolean equals(Object arg0) {
                if (this == arg0) {
                    return true;
                }
                if (arg0 == null) {
                    return false;
                }
                if (arg0.getClass() != this.getClass()) {
                    return false;
                }
                if (!Objects.equals(((SimpleLogEvent)arg0).getElement, this.getElement)) {
                    return false;
                }
                if (!Objects.equals(((SimpleLogEvent)arg0).getSubject, this.getSubject)) {
                    return false;
                }
                if (!Objects.equals((Object)((SimpleLogEvent)arg0).getStatus, (Object)this.getStatus)) {
                    return false;
                }
                if (((SimpleLogEvent)arg0).getDuration != this.getDuration) {
                    return false;
                }
                if (((SimpleLogEvent)arg0).getStartTime != this.getStartTime) {
                    return false;
                }
                if (((SimpleLogEvent)arg0).getEndTime != this.getEndTime) {
                    return false;
                }
                return Objects.equals(((SimpleLogEvent)arg0).getError, this.getError);
                {
                }
            }

            @Override
            public String getElement() {
                return this.getElement;
            }

            @Override
            public String getSubject() {
                return this.getSubject;
            }

            @Override
            public LogEvent.EventStatus getStatus() {
                return this.getStatus;
            }

            @Override
            public long getDuration() {
                return this.getDuration;
            }

            @Override
            public long getStartTime() {
                return this.getStartTime;
            }

            @Override
            public long getEndTime() {
                return this.getEndTime;
            }

            @Override
            public Throwable getError() {
                return this.getError;
            }
        }
    }
}

