/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Photographer;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public class WebdriverPhotographer
implements Photographer {
    @Override
    @Nonnull
    @CheckReturnValue
    public <T> Optional<T> takeScreenshot(Driver driver, OutputType<T> outputType) {
        WebDriver webDriver = driver.getWebDriver();
        if (webDriver instanceof TakesScreenshot) {
            TakesScreenshot takesScreenshot = (TakesScreenshot)webDriver;
            Object screenshot = takesScreenshot.getScreenshotAs(outputType);
            return Optional.of(screenshot);
        }
        return Optional.empty();
    }
}

