/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.drivercommands.CloseDriverCommand;
import com.codeborne.selenide.impl.Disposable;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public final class WebDriverInstance
implements Disposable {
    private final Config config;
    private final WebDriver webDriver;
    @Nullable
    private final SelenideProxyServer proxy;
    @Nullable
    private final DownloadsFolder downloadsFolder;
    private static final CloseDriverCommand closeDriverCommand = new CloseDriverCommand();

    public WebDriverInstance(Config config, WebDriver webDriver, @Nullable SelenideProxyServer proxy, @Nullable DownloadsFolder downloadsFolder) {
        Objects.requireNonNull(config, "config must not be null");
        Objects.requireNonNull(webDriver, "webDriver must not be null");
        this.config = config;
        this.webDriver = webDriver;
        this.proxy = proxy;
        this.downloadsFolder = downloadsFolder;
    }

    @Nonnull
    @CheckReturnValue
    public SelenideProxyServer proxy() {
        if (!this.config.proxyEnabled()) {
            throw new IllegalStateException("Proxy server is not enabled. You need to set proxyEnabled=true before opening a browser.");
        }
        if (this.proxy == null) {
            throw new IllegalStateException("config.proxyEnabled == true but proxy server is not created.");
        }
        if (!this.proxy.isStarted()) {
            throw new IllegalStateException("config.proxyEnabled == true but proxy server is not started.");
        }
        return this.proxy;
    }

    @Override
    public void dispose() {
        closeDriverCommand.close(this);
    }

    public String toString() {
        return "WebDriverInstance[" + "config=" + this.config + "," + "webDriver=" + this.webDriver + "," + "proxy=" + this.proxy + "," + "downloadsFolder=" + this.downloadsFolder + "]";
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        result = 31 * result + (this.webDriver != null ? this.webDriver.hashCode() : 0);
        result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
        result = 31 * result + (this.downloadsFolder != null ? this.downloadsFolder.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals(((WebDriverInstance)arg0).config, this.config)) {
            return false;
        }
        if (!Objects.equals(((WebDriverInstance)arg0).webDriver, this.webDriver)) {
            return false;
        }
        if (!Objects.equals(((WebDriverInstance)arg0).proxy, this.proxy)) {
            return false;
        }
        return Objects.equals(((WebDriverInstance)arg0).downloadsFolder, this.downloadsFolder);
        {
        }
    }

    public Config config() {
        return this.config;
    }

    public WebDriver webDriver() {
        return this.webDriver;
    }

    @Nullable
    public DownloadsFolder downloadsFolder() {
        return this.downloadsFolder;
    }
}

