/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.Clock;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.PageSourceExtractor;
import com.codeborne.selenide.impl.Photographer;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.Screenshot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ScreenShotLaboratory {
    private static final Logger log = LoggerFactory.getLogger(ScreenShotLaboratory.class);
    private static final ScreenShotLaboratory instance = new ScreenShotLaboratory();
    private static final Pattern REGEX_PLUS = Pattern.compile("\\+");
    private final Photographer photographer;
    private final PageSourceExtractor extractor;
    private final Clock clock;
    protected final List<Screenshot> allScreenshots = new ArrayList<Screenshot>();
    protected AtomicLong screenshotCounter = new AtomicLong();
    protected final ThreadLocal<String> currentContext = ThreadLocal.withInitial(() -> "");
    protected final ThreadLocal<List<Screenshot>> currentContextScreenshots = new ThreadLocal();
    protected final ThreadLocal<List<Screenshot>> threadScreenshots = ThreadLocal.withInitial(ArrayList::new);

    public static ScreenShotLaboratory getInstance() {
        return instance;
    }

    protected ScreenShotLaboratory() {
        this(Plugins.inject(Photographer.class), Plugins.inject(PageSourceExtractor.class), new Clock());
    }

    protected ScreenShotLaboratory(Photographer photographer, PageSourceExtractor extractor, Clock clock) {
        this.photographer = photographer;
        this.extractor = extractor;
        this.clock = clock;
    }

    @CheckReturnValue
    @Nonnull
    public Screenshot takeScreenShot(Driver driver, String className, String methodName) {
        return this.takeScreenshot(driver, this.getScreenshotFileName(className, methodName), true, true);
    }

    @CheckReturnValue
    @Nonnull
    protected String getScreenshotFileName(String className, String methodName) {
        return className.replace('.', File.separatorChar) + File.separatorChar + methodName + '.' + this.clock.timestamp();
    }

    @CheckReturnValue
    @Nonnull
    public Screenshot takeScreenshot(Driver driver, String fileName, boolean saveScreenshot, boolean savePageSource) {
        Screenshot screenshot = this.ifWebDriverStarted(driver, webDriver -> this.ifReportsFolderNotNull(driver.config(), config -> this.takeScreenShot((Config)config, driver, fileName, saveScreenshot, savePageSource)));
        return screenshot != null ? screenshot : Screenshot.none();
    }

    @CheckReturnValue
    @Nullable
    public <T> T takeScreenShot(Driver driver, OutputType<T> outputType) {
        return (T)this.ifWebDriverStarted(driver, webDriver -> this.photographer.takeScreenshot(driver, outputType).map(screenshot -> this.addToHistoryIfFile(driver.config(), screenshot, outputType)).orElse(null));
    }

    private <T> T addToHistoryIfFile(Config config, T screenshot, OutputType<T> outputType) {
        if (outputType == OutputType.FILE) {
            this.addToImageHistory(config, (File)screenshot);
        }
        return screenshot;
    }

    @CheckReturnValue
    @Nonnull
    private Screenshot takeScreenShot(Config config, Driver driver, String fileName, boolean saveScreenshot, boolean savePageSource) {
        File source = savePageSource ? this.savePageSourceToFile(config, fileName, driver) : null;
        File image = saveScreenshot ? this.savePageImageToFile(config, fileName, driver) : null;
        Screenshot screenshot = new Screenshot(image, this.toUrl(config, image), this.toUrl(config, source));
        this.addToHistory(screenshot);
        return screenshot;
    }

    @CheckReturnValue
    @Nullable
    public File takeScreenshot(Driver driver, WebElement element) {
        try {
            BufferedImage destination = this.takeScreenshotAsImage(driver, element);
            if (destination != null) {
                return this.writeToFile(driver, destination);
            }
        }
        catch (IOException e) {
            log.error("Failed to take screenshot of {}", (Object)element, (Object)e);
        }
        return null;
    }

    @CheckReturnValue
    @Nullable
    public BufferedImage takeScreenshotAsImage(Driver driver, WebElement element) {
        return this.ifWebDriverStarted(driver, webdriver -> this.ifReportsFolderNotNull(driver.config(), config -> this.takeElementScreenshotAsImage(driver, element).orElse(null)));
    }

    @CheckReturnValue
    @Nonnull
    private Optional<BufferedImage> takeElementScreenshotAsImage(Driver driver, WebElement element) {
        if (!(driver.getWebDriver() instanceof TakesScreenshot)) {
            log.warn("Cannot take screenshot because browser does not support screenshots");
            return Optional.empty();
        }
        try {
            byte[] screenshot = (byte[])element.getScreenshotAs(OutputType.BYTES);
            return Optional.of(this.imageFromBytes(screenshot));
        }
        catch (InvalidElementStateException elementIsNotVisible) {
            log.error("Failed to take element screenshot: {}", (Object)elementIsNotVisible.toString());
            return Optional.empty();
        }
    }

    private BufferedImage imageFromBytes(byte[] screenshot) {
        BufferedImage bufferedImage;
        ByteArrayInputStream in = new ByteArrayInputStream(screenshot);
        try {
            bufferedImage = ImageIO.read(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to take element screenshot", e);
            }
        }
        ((InputStream)in).close();
        return bufferedImage;
    }

    @CheckReturnValue
    @Nonnull
    protected String generateScreenshotFileName() {
        return this.currentContext.get() + this.clock.timestamp() + "." + this.screenshotCounter.getAndIncrement();
    }

    @CheckReturnValue
    @Nullable
    public File takeScreenshot(Driver driver, WebElement iframe, SelenideElement element) {
        try {
            BufferedImage destination = this.takeScreenshotAsImage(driver, iframe, element);
            if (destination != null) {
                return this.writeToFile(driver, destination);
            }
        }
        catch (IOException e) {
            log.error("Failed to take screenshot of {} inside frame {}", new Object[]{element, iframe, e});
        }
        return null;
    }

    @CheckReturnValue
    @Nonnull
    private File writeToFile(Driver driver, BufferedImage destination) throws IOException {
        File screenshotOfElement = new File(driver.config().reportsFolder(), this.generateScreenshotFileName() + ".png").getAbsoluteFile();
        FileHelper.ensureParentFolderExists(screenshotOfElement);
        ImageIO.write((RenderedImage)destination, "png", screenshotOfElement);
        return screenshotOfElement;
    }

    @CheckReturnValue
    @Nullable
    public BufferedImage takeScreenshotAsImage(Driver driver, WebElement iframe, SelenideElement element) {
        return this.ifWebDriverStarted(driver, webdriver -> this.ifReportsFolderNotNull(driver.config(), config -> this.takeElementScreenshotAsImage(driver, iframe, element)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @CheckReturnValue
    private BufferedImage takeElementScreenshotAsImage(Driver driver, WebElement iframe, SelenideElement element) {
        driver.switchTo().frame(iframe);
        try {
            WebElement webElement = element.toWebElement();
            BufferedImage bufferedImage = this.takeElementScreenshotAsImage(driver, webElement).orElse(null);
            return bufferedImage;
        }
        finally {
            driver.switchTo().parentFrame();
        }
    }

    @CheckReturnValue
    @Nullable
    public File takeScreenShotAsFile(Driver driver) {
        return this.ifWebDriverStarted(driver, webDriver -> {
            try {
                return this.photographer.takeScreenshot(driver, OutputType.FILE).map(imageFile -> this.addToImageHistory(driver.config(), (File)imageFile)).orElse(null);
            }
            catch (Exception e) {
                log.error("Failed to take screenshot in memory", (Throwable)e);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToHistory(Screenshot screenshot) {
        if (this.currentContextScreenshots.get() != null) {
            this.currentContextScreenshots.get().add(screenshot);
        }
        List<Screenshot> list = this.allScreenshots;
        synchronized (list) {
            this.allScreenshots.add(screenshot);
        }
        this.threadScreenshots.get().add(screenshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private File addToImageHistory(Config config, File imageFile) {
        Screenshot screenshot = new Screenshot(imageFile, this.toUrl(config, imageFile), null);
        if (this.currentContextScreenshots.get() != null) {
            this.currentContextScreenshots.get().add(screenshot);
        }
        List<Screenshot> list = this.allScreenshots;
        synchronized (list) {
            this.allScreenshots.add(screenshot);
        }
        this.threadScreenshots.get().add(screenshot);
        return imageFile;
    }

    @CheckReturnValue
    @Nullable
    protected File savePageImageToFile(Config config, String fileName, Driver driver) {
        try {
            Optional srcFile = this.photographer.takeScreenshot(driver, OutputType.BYTES);
            if (!srcFile.isPresent()) {
                log.info("Webdriver doesn't support screenshots");
                return null;
            }
            File imageFile = new File(config.reportsFolder(), fileName + ".png").getAbsoluteFile();
            ScreenShotLaboratory.writeToFileSafely((byte[])srcFile.get(), imageFile);
            return imageFile;
        }
        catch (WebDriverException e) {
            log.error("Failed to take screenshot to {}", (Object)fileName, (Object)e);
            return null;
        }
    }

    private static void writeToFileSafely(byte[] srcFile, File imageFile) {
        try {
            FileUtils.writeByteArrayToFile((File)imageFile, (byte[])srcFile);
        }
        catch (IOException e) {
            log.error("Failed to save screenshot to {}", (Object)imageFile, (Object)e);
        }
    }

    @CheckReturnValue
    @Nonnull
    protected File savePageSourceToFile(Config config, String fileName, Driver driver) {
        return this.extractor.extract(config, driver.getWebDriver(), fileName);
    }

    public void startContext(String className, String methodName) {
        String context = className.replace('.', File.separatorChar) + File.separatorChar + methodName + File.separatorChar;
        this.startContext(context);
    }

    public void startContext(String context) {
        this.currentContext.set(context);
        this.currentContextScreenshots.set(new ArrayList());
    }

    @Nonnull
    public List<Screenshot> finishContext() {
        List<Screenshot> result = this.currentContextScreenshots.get();
        this.currentContext.set("");
        this.currentContextScreenshots.remove();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    @Nonnull
    public List<File> getScreenshots() {
        List<Screenshot> list = this.allScreenshots;
        synchronized (list) {
            return this.allScreenshots.stream().map(screenshot -> screenshot.getImageFile()).filter(image -> image != null).collect(Collectors.toList());
        }
    }

    @CheckReturnValue
    @Nonnull
    public List<File> getThreadScreenshots() {
        List<Screenshot> screenshots = this.threadScreenshots.get();
        return ScreenShotLaboratory.streamOf(screenshots).map(screenshot -> screenshot.getImageFile()).collect(Collectors.toList());
    }

    @CheckReturnValue
    @Nonnull
    public List<Screenshot> threadScreenshots() {
        List<Screenshot> screenshots = this.threadScreenshots.get();
        return screenshots == null ? Collections.emptyList() : screenshots;
    }

    @CheckReturnValue
    @Nonnull
    public List<File> getContextScreenshots() {
        List<Screenshot> screenshots = this.currentContextScreenshots.get();
        return ScreenShotLaboratory.streamOf(screenshots).map(screenshot -> screenshot.getImageFile()).collect(Collectors.toList());
    }

    @CheckReturnValue
    @Nonnull
    public List<Screenshot> contextScreenshots() {
        List<Screenshot> screenshots = this.currentContextScreenshots.get();
        return screenshots == null ? Collections.emptyList() : screenshots;
    }

    @CheckReturnValue
    @Nullable
    public File getLastScreenshot() {
        Screenshot screenshot = this.lastScreenshot();
        return screenshot == null ? null : screenshot.getImageFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    @Nullable
    public Screenshot lastScreenshot() {
        List<Screenshot> list = this.allScreenshots;
        synchronized (list) {
            return this.allScreenshots.isEmpty() ? null : this.allScreenshots.get(this.allScreenshots.size() - 1);
        }
    }

    @CheckReturnValue
    @Nonnull
    public Optional<File> getLastThreadScreenshot() {
        List<File> screenshots = this.getThreadScreenshots();
        return this.getLastScreenshot(screenshots);
    }

    @CheckReturnValue
    @Nonnull
    public Optional<Screenshot> lastThreadScreenshot() {
        List<Screenshot> screenshots = this.threadScreenshots();
        return this.lastScreenshot(screenshots);
    }

    @CheckReturnValue
    @Nonnull
    public Optional<File> getLastContextScreenshot() {
        List<File> screenshots = this.getContextScreenshots();
        return this.getLastScreenshot(screenshots);
    }

    @CheckReturnValue
    @Nonnull
    public Optional<Screenshot> lastContextScreenshot() {
        List<Screenshot> screenshots = this.contextScreenshots();
        return this.lastScreenshot(screenshots);
    }

    @CheckReturnValue
    @Nonnull
    private Optional<File> getLastScreenshot(@Nullable List<File> screenshots) {
        return screenshots == null || screenshots.isEmpty() ? Optional.empty() : Optional.of(screenshots.get(screenshots.size() - 1));
    }

    @CheckReturnValue
    @Nonnull
    private Optional<Screenshot> lastScreenshot(@Nullable List<Screenshot> screenshots) {
        return screenshots == null || screenshots.isEmpty() ? Optional.empty() : Optional.of(screenshots.get(screenshots.size() - 1));
    }

    @CheckReturnValue
    @Nonnull
    public Screenshot takeScreenshot(Driver driver, boolean saveScreenshot, boolean savePageSource) {
        Screenshot screenshot = this.ifWebDriverStarted(driver, webDriver -> this.ifReportsFolderNotNull(driver.config(), config -> this.takeScreenShot((Config)config, driver, this.generateScreenshotFileName(), saveScreenshot, savePageSource)));
        return screenshot != null ? screenshot : Screenshot.none();
    }

    @CheckReturnValue
    @Nullable
    private String toUrl(Config config, @Nullable File file) {
        if (file == null) {
            return null;
        }
        if (config.reportsUrl() != null) {
            return this.formatScreenShotURL(config.reportsUrl(), file.getAbsolutePath());
        }
        try {
            return file.getCanonicalFile().toURI().toURL().toExternalForm();
        }
        catch (IOException e) {
            return "file://" + file.getAbsolutePath();
        }
    }

    @CheckReturnValue
    @Nonnull
    private String formatScreenShotURL(String reportsURL, String screenshot) {
        Path target;
        Path current = Paths.get(System.getProperty("user.dir"), new String[0]);
        String screenShotPath = ScreenShotLaboratory.isInsideFolder(current, target = Paths.get(screenshot, new String[0]).normalize()) ? current.relativize(target).toString().replace('\\', '/') : target.toFile().getName();
        return this.normalizeURL(reportsURL, screenShotPath);
    }

    @CheckReturnValue
    @Nonnull
    private String normalizeURL(String reportsURL, String path) {
        return this.appendSlash(reportsURL) + this.encodePath(path);
    }

    @CheckReturnValue
    @Nonnull
    private String appendSlash(String url) {
        return url.endsWith("/") ? url : url + "/";
    }

    @CheckReturnValue
    @Nonnull
    String encodePath(String path) {
        return REGEX_PLUS.matcher(Arrays.stream(path.split("/")).map(this::encode).collect(Collectors.joining("/"))).replaceAll("%20");
    }

    @CheckReturnValue
    @Nonnull
    private String encode(String str) {
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Cannot encode path segment: {}", (Object)str, (Object)e);
            return str;
        }
    }

    @CheckReturnValue
    private static boolean isInsideFolder(Path root, Path other) {
        return other.startsWith(root.toAbsolutePath());
    }

    @CheckReturnValue
    @Nullable
    private <T> T ifWebDriverStarted(Driver driver, Function<WebDriver, T> lambda) {
        if (!driver.hasWebDriverStarted()) {
            log.warn("Cannot take screenshot because browser is not started");
            return null;
        }
        return lambda.apply(driver.getWebDriver());
    }

    @CheckReturnValue
    @Nullable
    private <T> T ifReportsFolderNotNull(Config config, Function<Config, T> lambda) {
        if (config.reportsFolder() == null) {
            log.error("Cannot take screenshot because reportsFolder is null");
            return null;
        }
        return lambda.apply(config);
    }

    private static <T> Stream<T> streamOf(@Nullable List<T> list) {
        return list == null ? Stream.empty() : list.stream();
    }
}

