/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plugins {
    private static final Logger logger = LoggerFactory.getLogger(Plugins.class);
    private static final Map<Class<?>, Object> cache = new ConcurrentHashMap();

    public static synchronized <T> T inject(Class<T> klass) {
        Object plugin = cache.get(klass);
        if (plugin == null) {
            plugin = Plugins.loadPlugin(klass);
            cache.put(klass, plugin);
        }
        return (T)plugin;
    }

    private static <T> T loadPlugin(Class<T> klass) {
        Iterator<T> loader = ServiceLoader.load(klass).iterator();
        if (!loader.hasNext()) {
            T defaultPlugin = Plugins.getDefaultPlugin(klass);
            logger.debug("Using default implementation of {}: {}", (Object)klass.getName(), (Object)defaultPlugin.getClass().getName());
            return defaultPlugin;
        }
        T implementation = loader.next();
        logger.info("Using implementation of {}: {}", (Object)klass.getName(), (Object)implementation.getClass().getName());
        return implementation;
    }

    private static <T> T getDefaultPlugin(Class<T> klass) {
        String resource = "/META-INF/defaultservices/" + klass.getName();
        URL file = Plugins.class.getResource(resource);
        if (file == null) {
            throw new IllegalStateException("Resource not found in classpath: " + resource);
        }
        String className = Plugins.readFile(file).trim();
        try {
            return Plugins.instantiate(className, klass);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize default plugin " + className + " from " + file, e);
        }
    }

    @Nonnull
    private static <T> T instantiate(String className, Class<T> klass) throws Exception {
        Constructor<T> constructor = Class.forName(className).asSubclass(klass).getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    private static String readFile(URL file) {
        try {
            return IOUtils.toString((URL)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + file, e);
        }
    }
}

