/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Html {
    private static final Pattern REGEX_SPACES = Pattern.compile("[\\s\\n\\r\u00a0]+");
    public static Html text = new Html();

    public boolean matches(String text, String regex) {
        return Pattern.compile(regex, 32).matcher(text).matches();
    }

    public boolean matchesSubstring(String text, String regex) {
        return Pattern.compile(".*" + regex + ".*", 32).matcher(text).matches();
    }

    public boolean contains(String text, String subtext) {
        return this.reduceSpaces(text.toLowerCase(Locale.ROOT)).contains(this.reduceSpaces(subtext.toLowerCase(Locale.ROOT)));
    }

    public boolean containsCaseSensitive(String text, String subtext) {
        return this.reduceSpaces(text).contains(this.reduceSpaces(subtext));
    }

    public boolean equals(String text, String subtext) {
        return this.reduceSpaces(text).equalsIgnoreCase(this.reduceSpaces(subtext));
    }

    public boolean equalsCaseSensitive(String text, String subtext) {
        return this.reduceSpaces(text).equals(this.reduceSpaces(subtext));
    }

    public String reduceSpaces(String text) {
        return REGEX_SPACES.matcher(text).replaceAll(" ").trim();
    }
}

