/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSelector;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ElementFinder
extends WebElementSource {
    private final WebElementSelector elementSelector = Plugins.inject(WebElementSelector.class);
    private final ElementDescriber describe = Plugins.inject(ElementDescriber.class);
    private final Driver driver;
    private final WebElementSource parent;
    private final By criteria;
    private final int index;

    @CheckReturnValue
    @Nonnull
    public static SelenideElement wrap(Driver driver, String cssSelector, int index) {
        return ElementFinder.wrap(driver, null, By.cssSelector((String)cssSelector), index);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement wrap(Driver driver, By criteria) {
        return ElementFinder.wrap(driver, null, criteria, 0);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement wrap(Driver driver, @Nullable WebElementSource parent, By criteria, int index) {
        return ElementFinder.wrap(driver, SelenideElement.class, parent, criteria, index);
    }

    @CheckReturnValue
    @Nonnull
    public static <T extends SelenideElement> T wrap(Driver driver, Class<T> clazz, @Nullable WebElementSource parent, By criteria, int index) {
        return ElementFinder.wrap(driver, clazz, parent, criteria, index, null);
    }

    @CheckReturnValue
    @Nonnull
    public static <T extends SelenideElement> T wrap(Driver driver, Class<T> clazz, @Nullable WebElementSource parent, By criteria, int index, @Nullable String alias) {
        return (T)((SelenideElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new SelenideElementProxy(new ElementFinder(driver, parent, criteria, index, alias))));
    }

    @CheckReturnValue
    @Nonnull
    public static <T extends SelenideElement> T wrap(Class<T> clazz, WebElementSource element) {
        return (T)((SelenideElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new SelenideElementProxy(element)));
    }

    ElementFinder(Driver driver, @Nullable WebElementSource parent, By criteria, int index) {
        this(driver, parent, criteria, index, null);
    }

    ElementFinder(Driver driver, @Nullable WebElementSource parent, By criteria, int index, @Nullable String alias) {
        this.driver = driver;
        this.parent = parent;
        this.criteria = criteria;
        this.index = index;
        if (alias != null) {
            this.setAlias(alias);
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public SelenideElement find(SelenideElement proxy, Object arg, int index) {
        if (arg instanceof By) {
            By by = (By)arg;
            return ElementFinder.wrap(this.driver, this, by, index);
        }
        if (arg instanceof String) {
            String cssLocator = (String)arg;
            return ElementFinder.wrap(this.driver, this, By.cssSelector((String)cssLocator), index);
        }
        throw new IllegalArgumentException("Unsupported locator type: " + arg);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.driver;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getWebElement() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.elementSelector.findElement(this.driver, this.parent, this.criteria, this.index);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> findAll() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.index == 0 ? this.elementSelector.findElements(this.driver(), this.parent, this.criteria) : super.findAll();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ElementNotFound createElementNotFoundError(Condition condition, Throwable cause) {
        if (this.parent != null) {
            this.parent.checkCondition("", Condition.exist, false);
        }
        return super.createElementNotFoundError(condition, cause);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return this.parent == null ? this.elementCriteria() : this.parent.getSearchCriteria() + "/" + this.elementCriteria();
    }

    @Nonnull
    private String elementCriteria() {
        return this.index == 0 ? this.describe.selector(this.criteria) : this.describe.selector(this.criteria) + '[' + this.index + ']';
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String toString() {
        return "{" + this.description() + '}';
    }
}

