/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.impl.Screenshot;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

public interface ErrorFormatter {
    @CheckReturnValue
    @Nonnull
    public String generateErrorDetails(AssertionError var1, Driver var2, Screenshot var3, long var4);

    @CheckReturnValue
    @Nonnull
    default public <T> String formatActualValue(@Nullable String actualValue) {
        return actualValue == null ? "" : String.format("Actual value: %s", actualValue);
    }

    @CheckReturnValue
    @Nonnull
    public String actualValue(Condition var1, Driver var2, @Nullable WebElement var3, @Nullable CheckResult var4);

    @CheckReturnValue
    @Nullable
    default public <T> String extractActualValue(ObjectCondition<T> condition, @Nonnull T object) {
        try {
            return condition.actualValue(object);
        }
        catch (RuntimeException failedToGetValue) {
            String failedActualValue = failedToGetValue.getClass().getSimpleName() + ": " + failedToGetValue.getMessage();
            return StringUtils.substring((String)failedActualValue, (int)0, (int)50);
        }
    }
}

