/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.drivercommands.BrowserHealthChecker;
import com.codeborne.selenide.impl.WebDriverInstance;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class WebDriverWrapper
implements Driver {
    private static final Logger log = LoggerFactory.getLogger(WebDriverWrapper.class);
    private final WebDriverInstance wd;
    private final BrowserHealthChecker browserHealthChecker = new BrowserHealthChecker();

    public WebDriverWrapper(Config config, WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, DownloadsFolder browserDownloadsFolder) {
        this(new WebDriverInstance(config, webDriver, selenideProxy, browserDownloadsFolder));
    }

    private WebDriverWrapper(WebDriverInstance wd) {
        this.wd = wd;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Config config() {
        return this.wd.config();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Browser browser() {
        return new Browser(this.wd.config().browser(), this.wd.config().headless());
    }

    @Override
    @CheckReturnValue
    public boolean hasWebDriverStarted() {
        return this.wd.webDriver() != null;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver getWebDriver() {
        return this.wd.webDriver();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public SelenideProxyServer getProxy() {
        return this.wd.proxy();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver getAndCheckWebDriver() {
        if (this.wd.webDriver() == null || !this.browserHealthChecker.isBrowserStillOpen(this.wd.webDriver())) {
            log.info("Webdriver has been closed meanwhile");
            this.close();
            throw new IllegalStateException("Webdriver has been closed meanwhile");
        }
        return this.wd.webDriver();
    }

    @Override
    @CheckReturnValue
    @Nullable
    public DownloadsFolder browserDownloadsFolder() {
        return this.wd.downloadsFolder();
    }

    @Override
    public void close() {
        this.wd.dispose();
    }
}

