/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.ObjectCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public class Title
implements ObjectCondition<WebDriver> {
    private final String title;

    public Title(String title) {
        this.title = title;
    }

    @Override
    @Nullable
    public String actualValue(WebDriver webDriver) {
        return webDriver.getTitle();
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return this.title;
    }

    @Override
    @Nonnull
    public String description() {
        return "should have title " + this.title;
    }

    @Override
    @Nonnull
    public String negativeDescription() {
        return "should not have title " + this.title;
    }

    @Override
    @Nonnull
    public String describe(WebDriver webDriver) {
        return "Page";
    }

    @Override
    @CheckReturnValue
    public boolean test(WebDriver webDriver) {
        return webDriver.getTitle().equals(this.title);
    }
}

