/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.TextCheck;
import com.codeborne.selenide.conditions.TextCondition;
import com.codeborne.selenide.impl.Html;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;

@ParametersAreNonnullByDefault
public class MatchText
extends TextCondition {
    public MatchText(String regex) {
        super("match text", regex);
        if (StringUtils.isEmpty((CharSequence)regex)) {
            throw new IllegalArgumentException("Argument must not be null or empty string");
        }
    }

    @Override
    @CheckReturnValue
    protected boolean match(String actualText, String expectedText) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean match(TextCheck textCheck, String actualText, String expectedText) {
        boolean bl;
        switch (textCheck) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FULL_TEXT: {
                bl = Html.text.matches(actualText, expectedText);
                break;
            }
            case PARTIAL_TEXT: {
                bl = Html.text.matchesSubstring(actualText, expectedText);
            }
        }
        return bl;
    }
}

