/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.commands.GetSelectedOptionText;
import com.codeborne.selenide.conditions.CaseSensitiveTextCondition;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class CaseSensitiveText
extends CaseSensitiveTextCondition {
    private final GetSelectedOptionText getSelectedOptionText;

    public CaseSensitiveText(String expectedText) {
        this(expectedText, new GetSelectedOptionText());
    }

    CaseSensitiveText(String expectedText, GetSelectedOptionText getSelectedOptionText) {
        super("text case sensitive", expectedText);
        this.getSelectedOptionText = getSelectedOptionText;
    }

    @Override
    @Nullable
    @CheckReturnValue
    protected String getText(Driver driver, WebElement element) {
        return "select".equalsIgnoreCase(element.getTagName()) ? this.getSelectedOptionText.execute(driver, element) : element.getText();
    }
}

