/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.WebElementSource;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class Clear
implements Command<SelenideElement> {
    private static final Logger log = LoggerFactory.getLogger(Clear.class);

    @Override
    @Nonnull
    @CheckReturnValue
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, @Nullable Object[] args) {
        WebElement input = locator.findAndAssertElementIsEditable();
        this.clearAndTrigger(locator.driver(), input);
        return proxy;
    }

    protected void clearAndTrigger(Driver driver, WebElement input) {
        this.clear(driver, input);
        this.blurSafely(driver, input);
    }

    protected void blurSafely(Driver driver, WebElement input) {
        try {
            driver.executeJavaScript("arguments[0].blur()", input);
        }
        catch (StaleElementReferenceException elementHasDisappeared) {
            log.debug("The input has disappeared after clearing: {}", (Object)elementHasDisappeared.toString());
        }
    }

    public void clear(Driver driver, WebElement input) {
        input.clear();
    }
}

