/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.collections.ExactTexts;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.Html;
import com.codeborne.selenide.impl.Plugins;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ExactTextsCaseSensitiveInAnyOrder
extends ExactTexts {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);

    public ExactTextsCaseSensitiveInAnyOrder(String ... exactTexts) {
        super(exactTexts);
    }

    public ExactTextsCaseSensitiveInAnyOrder(List<String> exactTexts) {
        super(exactTexts);
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, List<WebElement> elements) {
        if (elements.size() != this.expectedTexts.size()) {
            return new CheckResult(CheckResult.Verdict.REJECT, (Object)elements.size());
        }
        List<String> actualTexts = communicator.texts(driver, elements);
        for (int i = 0; i < this.expectedTexts.size(); ++i) {
            String expectedText = (String)this.expectedTexts.get(i);
            if (this.find(actualTexts, expectedText)) continue;
            String message = String.format("Text #%s not found: \"%s\"", i, expectedText);
            return CheckResult.rejected(message, actualTexts);
        }
        return CheckResult.accepted();
    }

    private boolean find(List<String> texts, String text) {
        for (String actualText : texts) {
            if (!Html.text.equalsCaseSensitive(actualText, text)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "Exact texts case sensitive in any order " + this.expectedTexts;
    }
}

