/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.AttributesMismatch;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.ListSizeMismatch;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.Plugins;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Attributes
extends CollectionCondition {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    protected final List<String> expectedValues;
    protected final String attribute;

    public Attributes(String attribute, List<String> expectedValues) {
        if (expectedValues.isEmpty()) {
            throw new IllegalArgumentException("No expected values given for attribute " + attribute);
        }
        this.expectedValues = Collections.unmodifiableList(expectedValues);
        this.attribute = attribute;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, List<WebElement> elements) {
        if (elements.size() != this.expectedValues.size()) {
            return new CheckResult(CheckResult.Verdict.REJECT, (Object)elements.size());
        }
        List<String> actualAttributeValues = communicator.attributes(driver, elements, this.attribute);
        for (int i = 0; i < this.expectedValues.size(); ++i) {
            String expectedValue = this.expectedValues.get(i);
            String actualValue = actualAttributeValues.get(i);
            if (Objects.equals(actualValue, expectedValue)) continue;
            String message = String.format("Attribute \"%s\" values mismatch (#%s expected: \"%s\", actual: \"%s\")", this.attribute, i, expectedValue, actualValue);
            return CheckResult.rejected(message, actualAttributeValues);
        }
        return CheckResult.accepted();
    }

    @Override
    public void fail(CollectionSource collection, CheckResult lastCheckResult, @Nullable Exception cause, long timeoutMs) {
        Object object = lastCheckResult.actualValue();
        if (object instanceof Integer) {
            Integer actualSize = (Integer)object;
            if (actualSize == 0) {
                throw new ElementNotFound(collection, this.toString(), timeoutMs, (Throwable)cause);
            }
            throw new ListSizeMismatch("=", this.expectedValues.size(), actualSize, this.explanation, collection, cause, timeoutMs);
        }
        List actualAttributeValues = (List)lastCheckResult.requireActualValue();
        if (actualAttributeValues.isEmpty()) {
            throw new ElementNotFound(collection, this.toString(), timeoutMs, (Throwable)cause);
        }
        String message = lastCheckResult.getMessageOrElse(() -> String.format("Attribute '%s' values mismatch", this.attribute));
        throw new AttributesMismatch(collection.driver(), message, collection, this.expectedValues, actualAttributeValues, this.explanation, timeoutMs, cause);
    }

    @Override
    public boolean missingElementSatisfiesCondition() {
        return false;
    }

    public String toString() {
        return "Attribute: '" + this.attribute + "' values " + this.expectedValues;
    }
}

