/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PropertiesReader {
    private static final Logger log = LoggerFactory.getLogger(PropertiesReader.class);
    private final String fileName;
    private Properties properties;

    PropertiesReader(String fileName) {
        this.fileName = fileName;
    }

    public synchronized String getProperty(String key, String defaultValue) {
        if (this.properties == null) {
            this.properties = this.loadSelenideProperties();
        }
        return this.properties.getProperty(key, defaultValue);
    }

    private Properties loadSelenideProperties() {
        Properties properties = new Properties();
        this.loadPropertiesFrom(Thread.currentThread().getContextClassLoader(), properties);
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    private void loadPropertiesFrom(ClassLoader classLoader, Properties properties) {
        try (InputStream stream = classLoader.getResourceAsStream(this.fileName);){
            if (stream != null) {
                log.debug("Reading settings from {}", (Object)classLoader.getResource(this.fileName));
                properties.load(stream);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + this.fileName + " file from classpath", e);
        }
    }
}

