/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.pdftest.matchers;

import com.codeborne.pdftest.PDF;
import com.codeborne.pdftest.matchers.PDFMatcher;
import java.util.regex.Pattern;
import org.hamcrest.Description;

public class MatchesText
extends PDFMatcher {
    private final Pattern expectedText;

    public MatchesText(Pattern expectedText) {
        this.expectedText = expectedText;
    }

    protected boolean matchesSafely(PDF item) {
        String reducedPdfText = this.reduceSpaces(item.text);
        return this.expectedText.matcher(reducedPdfText).matches();
    }

    protected void describeMismatchSafely(PDF item, Description mismatchDescription) {
        mismatchDescription.appendText("was \"").appendText(this.reduceSpaces(item.text)).appendText("\"");
    }

    public void describeTo(Description description) {
        description.appendText("a PDF matching ");
        this.buildErrorMessage(description, this.expectedText.toString(), new String[0]);
    }
}

