/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.pdftest.assertj;

import com.codeborne.pdftest.PDF;
import com.codeborne.pdftest.matchers.ContainsExactText;
import com.codeborne.pdftest.matchers.ContainsText;
import com.codeborne.pdftest.matchers.ContainsTextCaseInsensitive;
import com.codeborne.pdftest.matchers.DoesNotContainExactText;
import com.codeborne.pdftest.matchers.DoesNotContainText;
import com.codeborne.pdftest.matchers.MatchesText;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractAssert;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class PdfAssert
extends AbstractAssert<PdfAssert, PDF> {
    public PdfAssert(PDF actual) {
        super((Object)actual, PdfAssert.class);
    }

    public PdfAssert containsText(String text, String ... texts) {
        this.isNotNull();
        MatcherAssert.assertThat((Object)this.actual, (Matcher)new ContainsText(text, texts));
        return this;
    }

    public PdfAssert doesNotContainText(String text, String ... texts) {
        this.isNotNull();
        MatcherAssert.assertThat((Object)this.actual, (Matcher)new DoesNotContainText(text, texts));
        return this;
    }

    public PdfAssert containsExactText(String substring) {
        this.isNotNull();
        MatcherAssert.assertThat((Object)this.actual, (Matcher)new ContainsExactText(substring));
        return this;
    }

    public PdfAssert doesNotContainExactText(String substring) {
        this.isNotNull();
        MatcherAssert.assertThat((Object)this.actual, (Matcher)new DoesNotContainExactText(substring));
        return this;
    }

    public PdfAssert containsTextCaseInsensitive(String substring) {
        this.isNotNull();
        MatcherAssert.assertThat((Object)this.actual, (Matcher)new ContainsTextCaseInsensitive(substring));
        return this;
    }

    public PdfAssert matchesText(String regex) {
        return this.matchesText(Pattern.compile(regex));
    }

    public PdfAssert matchesText(Pattern regex) {
        this.isNotNull();
        MatcherAssert.assertThat((Object)this.actual, (Matcher)new MatchesText(regex));
        return this;
    }
}

