/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.httpclient;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultRequestDirector;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;

class InstrumentedRequestDirector
extends DefaultRequestDirector {
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String HEAD = "HEAD";
    private static final String PUT = "PUT";
    private static final String OPTIONS = "OPTIONS";
    private static final String DELETE = "DELETE";
    private static final String TRACE = "TRACE";
    private static final String CONNECT = "CONNECT";
    private static final String MOVE = "MOVE";
    private static final String PATCH = "PATCH";
    private final Timer getTimer;
    private final Timer postTimer;
    private final Timer headTimer;
    private final Timer putTimer;
    private final Timer deleteTimer;
    private final Timer optionsTimer;
    private final Timer traceTimer;
    private final Timer connectTimer;
    private final Timer moveTimer;
    private final Timer patchTimer;
    private final Timer otherTimer;

    InstrumentedRequestDirector(MetricRegistry registry, String name, Log log, HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectStrategy redirectStrategy, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler, HttpParams params) {
        super(log, requestExec, conman, reustrat, kastrat, rouplan, httpProcessor, retryHandler, redirectStrategy, targetAuthStrategy, proxyAuthStrategy, userTokenHandler, params);
        this.getTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "get-requests"}));
        this.postTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "post-requests"}));
        this.headTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "head-requests"}));
        this.putTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "put-requests"}));
        this.deleteTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "delete-requests"}));
        this.optionsTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "options-requests"}));
        this.traceTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "trace-requests"}));
        this.connectTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "connect-requests"}));
        this.moveTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "move-requests"}));
        this.patchTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "patch-requests"}));
        this.otherTimer = registry.timer(MetricRegistry.name(HttpClient.class, (String[])new String[]{name, "other-requests"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException, IOException {
        Timer.Context timerContext = this.timer(request).time();
        try {
            HttpResponse httpResponse = super.execute(target, request, context);
            return httpResponse;
        }
        finally {
            timerContext.stop();
        }
    }

    private Timer timer(HttpRequest request) {
        String method = request.getRequestLine().getMethod();
        if (GET.equalsIgnoreCase(method)) {
            return this.getTimer;
        }
        if (POST.equalsIgnoreCase(method)) {
            return this.postTimer;
        }
        if (PUT.equalsIgnoreCase(method)) {
            return this.putTimer;
        }
        if (HEAD.equalsIgnoreCase(method)) {
            return this.headTimer;
        }
        if (DELETE.equalsIgnoreCase(method)) {
            return this.deleteTimer;
        }
        if (OPTIONS.equalsIgnoreCase(method)) {
            return this.optionsTimer;
        }
        if (TRACE.equalsIgnoreCase(method)) {
            return this.traceTimer;
        }
        if (CONNECT.equalsIgnoreCase(method)) {
            return this.connectTimer;
        }
        if (PATCH.equalsIgnoreCase(method)) {
            return this.patchTimer;
        }
        if (MOVE.equalsIgnoreCase(method)) {
            return this.moveTimer;
        }
        return this.otherTimer;
    }
}

